/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\u0001\u0003\u0001\ta!aE&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0016\u0005512C\u0001\u0001\u000f!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u000bSK\u000e,\u0017N^3s\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001B0tg\u000e\u0004\"AJ\u0014\u000e\u0003\u0011I!\u0001\u000b\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0015M$(/Z1n\u001d\u0006lW\r\u0005\u0002-_9\u00111$L\u0005\u0003]q\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011a\u0006\b\u0005\tg\u0001\u0011\t\u0011)A\u0005W\u0005YQM\u001c3q_&tG/\u0016:m\u0011!)\u0004A!A!\u0002\u0013Y\u0013A\u0003:fO&|gNT1nK\"Aq\u0007\u0001B\u0001B\u0003%\u0001(A\fj]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[B\u0011\u0011hR\u0007\u0002u)\u00111\bP\u0001\u0007o>\u00148.\u001a:\u000b\u0005ur\u0014a\u00017jE*\u0011q\bQ\u0001\u000eG2LWM\u001c;mS\n\u0014\u0018M]=\u000b\u0005\r\t%B\u0001\"D\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001#F\u0003%\tW.\u0019>p]\u0006<8OC\u0001G\u0003\r\u0019w.\\\u0005\u0003\u0011j\u0012q#\u00138ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7\t\u0011)\u0003!\u0011!Q\u0001\n-\n\u0011c\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f\u0011!a\u0005A!A!\u0002\u0013i\u0015AE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2\u0004\"A\n(\n\u0005=#!\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u0011E\u0003!\u0011!Q\u0001\nI\u000bAb\u001d;pe\u0006<W\rT3wK2\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u0004\u0002\u000fM$xN]1hK&\u0011q\u000b\u0016\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\t3\u0002\u0011\t\u0011)A\u00055\u0006qQ.Z:tC\u001e,\u0007*\u00198eY\u0016\u0014\b\u0003B\u000e\\;RI!\u0001\u0018\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u00010b\u001b\u0005y&B\u00011A\u0003\u0015iw\u000eZ3m\u0013\t\u0011wL\u0001\u0004SK\u000e|'\u000f\u001a\u0005\tI\u0002\u0011\t\u0011)A\u0005K\u0006!\u0012m^:De\u0016$WM\u001c;jC2\u001cx\n\u001d;j_:\u00042a\u00074i\u0013\t9GD\u0001\u0004PaRLwN\u001c\t\u0003S*l\u0011AA\u0005\u0003W\n\u0011!dU3sS\u0006d\u0017N_1cY\u0016\fukU\"sK\u0012,g\u000e^5bYND\u0001\"\u001c\u0001\u0003\u0004\u0003\u0006YA\\\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA8s)5\t\u0001O\u0003\u0002r9\u00059!/\u001a4mK\u000e$\u0018BA:q\u0005!\u0019E.Y:t)\u0006<\u0007\"B;\u0001\t\u00031\u0018A\u0002\u001fj]&$h\bF\bxundXP`@\u0002\u0002\u0005\r\u0011QAA\u0004)\tA\u0018\u0010E\u0002j\u0001QAQ!\u001c;A\u00049DQ\u0001\n;A\u0002\u0015BQA\u000b;A\u0002-BQa\r;A\u0002-BQ!\u000e;A\u0002-BQa\u000e;A\u0002aBQA\u0013;A\u0002-BQ\u0001\u0014;A\u00025CQ!\u0015;A\u0002ICQ!\u0017;A\u0002iCQ\u0001\u001a;A\u0002\u0015D\u0001\"a\u0003\u0001\t\u0003\"\u0011QB\u0001\u000fGJ,\u0017\r^3CY>\u001c7N\u0015#E)\u0019\ty!a\u0007\u0002&A)\u0011\u0011CA\f)5\u0011\u00111\u0003\u0006\u0004\u0003+1\u0011a\u0001:eI&!\u0011\u0011DA\n\u0005\r\u0011F\t\u0012\u0005\t\u0003;\tI\u00011\u0001\u0002 \u0005!A/[7f!\r1\u0013\u0011E\u0005\u0004\u0003G!!\u0001\u0002+j[\u0016D\u0001\"a\n\u0002\n\u0001\u0007\u0011\u0011F\u0001\u000bE2|7m[%oM>\u001c\bCBA\u0016\u0003w\t\tE\u0004\u0003\u0002.\u0005]b\u0002BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0002$\u0001\u0004=e>|GOP\u0005\u0002;%\u0019\u0011\u0011\b\u000f\u0002\u000fA\f7m[1hK&!\u0011QHA \u0005\r\u0019V-\u001d\u0006\u0004\u0003sa\u0002\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC!A\u0005tG\",G-\u001e7fe&!\u00111JA#\u0005E\u0011VmY3jm\u0016$'\t\\8dW&sgm\u001c\u0005\b\u0003\u001f\u0002A\u0011IA)\u0003-9W\r\u001e*fG\u0016Lg/\u001a:\u0015\u0005\u0005M\u0003#BA+\u00037\"RBAA,\u0015\r\tI\u0006B\u0001\te\u0016\u001cW-\u001b<fe&!\u0011QLA,\u0005!\u0011VmY3jm\u0016\u0014\b")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel storageLevel;
    private final Function1<Record, T> messageHandler;
    private final Option<SerializableAWSCredentials> awsCredentialsOption;
    private final ClassTag<T> evidence$1;

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(ReceivedBlockInfo x$1) {
                return x$1.metadataOption();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> x$2) {
                return x$2.nonEmpty();
            }
        });
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$3) {
                    return x$3.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceNumberRanges apply(ReceivedBlockInfo x$4) {
                    return (SequenceNumberRanges)x$4.metadataOption().get();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$5) {
                    return x$5.isBlockIdValid();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0)new Serializable(this, time, seqNumRanges){
                public static final long serialVersionUID = 0L;
                private final Time time$1;
                private final SequenceNumberRanges[] seqNumRanges$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating KinesisBackedBlockRDD for ", " with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.time$1, BoxesRunTime.boxToInteger((int)this.seqNumRanges$1.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seq number ranges: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.seqNumRanges$1).mkString(", ")}))).toString();
                }
                {
                    void var3_3;
                    this.time$1 = time$1;
                    this.seqNumRanges$1 = var3_3;
                }
            });
            object = new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName, this.endpointUrl, blockIds, seqNumRanges, isBlockIdValid, (int)this.ssc().graph().batchDuration().milliseconds(), this.messageHandler, this.awsCredentialsOption, this.evidence$1);
        } else {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures";
                }
            });
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName, this.endpointUrl, this.regionName, this.initialPositionInStream, this.checkpointAppName, this.checkpointInterval, this.storageLevel, this.messageHandler, this.awsCredentialsOption);
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, Option<SerializableAWSCredentials> awsCredentialsOption, ClassTag<T> evidence$1) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.storageLevel = storageLevel;
        this.messageHandler = messageHandler;
        this.awsCredentialsOption = awsCredentialsOption;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }
}

