/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Record;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%gAB\u0001\u0003\u0001\taAOA\bLS:,7/[:SK\u000e,\u0017N^3s\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0017'\r\u0001ab\t\t\u0004\u001fI!R\"\u0001\t\u000b\u0005E!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\n\u0005M\u0001\"\u0001\u0003*fG\u0016Lg/\u001a:\u0011\u0005U1B\u0002\u0001\u0003\u0006/\u0001\u0011\r!\u0007\u0002\u0002)\u000e\u0001\u0011C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011aEB\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0011!Q\u0003A!b\u0001\n\u0003Y\u0013AC:ue\u0016\fWNT1nKV\tA\u0006\u0005\u0002.a9\u00111DL\u0005\u0003_q\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006\b\u0005\ti\u0001\u0011\t\u0011)A\u0005Y\u0005Y1\u000f\u001e:fC6t\u0015-\\3!\u0011!1\u0004A!A!\u0002\u0013a\u0013aC3oIB|\u0017N\u001c;Ve2D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000be\u0016<\u0017n\u001c8OC6,\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002/%t\u0017\u000e^5bYB{7/\u001b;j_:Len\u0015;sK\u0006l\u0007C\u0001\u001fK\u001b\u0005i$B\u0001 @\u0003\u00199xN]6fe*\u0011\u0001)Q\u0001\u0004Y&\u0014'B\u0001\"D\u00035\u0019G.[3oi2L'M]1ss*\u00111\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u000f\"\u000b\u0011\"Y7bu>t\u0017m^:\u000b\u0003%\u000b1aY8n\u0013\tYUHA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\"AQ\n\u0001B\u0001B\u0003%A&A\tdQ\u0016\u001c7\u000e]8j]R\f\u0005\u000f\u001d(b[\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0005\u0002R%6\tA!\u0003\u0002T\t\tAA)\u001e:bi&|g\u000eC\u0005V\u0001\t\u0005\t\u0015!\u0003W9\u0006a1\u000f^8sC\u001e,G*\u001a<fYB\u0011qKW\u0007\u00021*\u0011\u0011LB\u0001\bgR|'/Y4f\u0013\tY\u0006L\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G.\u0003\u0002V%!Aa\f\u0001B\u0001B\u0003%q,\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\tm\u0001'\rF\u0005\u0003Cr\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u001c\u0015!B7pI\u0016d\u0017BA4e\u0005\u0019\u0011VmY8sI\"A\u0011\u000e\u0001B\u0001B\u0003%!.\u0001\u000bboN\u001c%/\u001a3f]RL\u0017\r\\:PaRLwN\u001c\t\u00047-l\u0017B\u00017\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011an\\\u0007\u0002\u0005%\u0011\u0001O\u0001\u0002\u001b'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z!X'\u000e\u0013X\rZ3oi&\fGn\u001d\u0005\u0006e\u0002!\ta]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015Q,ho\u001e=zundX\u0010E\u0002o\u0001QAQAK9A\u00021BQAN9A\u00021BQ\u0001O9A\u00021BQAO9A\u0002mBQ!T9A\u00021BQaT9A\u0002ACQ!V9A\u0002YCQAX9A\u0002}CQ![9A\u0002)Dqa \u0001A\u0002\u0013%1&\u0001\u0005x_J\\WM]%e\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)!\u0001\u0007x_J\\WM]%e?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00055\u0001cA\u000e\u0002\n%\u0019\u00111\u0002\u000f\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001f\t\t!!AA\u00021\n1\u0001\u001f\u00132\u0011\u001d\t\u0019\u0002\u0001Q!\n1\n\u0011b^8sW\u0016\u0014\u0018\n\u001a\u0011)\t\u0005E\u0011q\u0003\t\u00047\u0005e\u0011bAA\u000e9\tAao\u001c7bi&dW\r\u0003\u0005?\u0001\u0001\u0007I\u0011BA\u0010+\t\t\t\u0003E\u0002=\u0003GI1!!\n>\u0005\u00199vN]6fe\"I\u0011\u0011\u0006\u0001A\u0002\u0013%\u00111F\u0001\u000bo>\u00148.\u001a:`I\u0015\fH\u0003BA\u0004\u0003[A!\"a\u0004\u0002(\u0005\u0005\t\u0019AA\u0011\u0011!\t\t\u0004\u0001Q!\n\u0005\u0005\u0012aB<pe.,'\u000f\t\u0015\u0005\u0003_\t9\u0002C\u0005\u00028\u0001\u0001\r\u0011\"\u0003\u0002:\u0005aqo\u001c:lKJ$\u0006N]3bIV\u0011\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002@\t1A\u000b\u001b:fC\u0012D\u0011\"!\u0014\u0001\u0001\u0004%I!a\u0014\u0002!]|'o[3s)\"\u0014X-\u00193`I\u0015\fH\u0003BA\u0004\u0003#B!\"a\u0004\u0002L\u0005\u0005\t\u0019AA\u001e\u0011!\t)\u0006\u0001Q!\n\u0005m\u0012!D<pe.,'\u000f\u00165sK\u0006$\u0007\u0005\u000b\u0003\u0002T\u0005]\u0001\"CA.\u0001\u0001\u0007I\u0011BA/\u00039\u0011Gn\\2l\u000f\u0016tWM]1u_J,\"!a\u0018\u0011\u0007=\t\t'C\u0002\u0002dA\u0011aB\u00117pG.<UM\\3sCR|'\u000fC\u0005\u0002h\u0001\u0001\r\u0011\"\u0003\u0002j\u0005\u0011\"\r\\8dW\u001e+g.\u001a:bi>\u0014x\fJ3r)\u0011\t9!a\u001b\t\u0015\u0005=\u0011QMA\u0001\u0002\u0004\ty\u0006\u0003\u0005\u0002p\u0001\u0001\u000b\u0015BA0\u0003=\u0011Gn\\2l\u000f\u0016tWM]1u_J\u0004\u0003\u0006BA7\u0003/A\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\u00025M,\u0017OT;n%\u0006tw-Z:J]\u000e+(O]3oi\ncwnY6\u0016\u0005\u0005e\u0004CBA>\u0003\u000b\u000bI)\u0004\u0002\u0002~)!\u0011qPAA\u0003\u001diW\u000f^1cY\u0016T1!a!\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\u000biHA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u00018\u0002\f&\u0019\u0011Q\u0012\u0002\u0003'M+\u0017/^3oG\u0016tU/\u001c2feJ\u000bgnZ3\t\u0011\u0005E\u0005\u0001)A\u0005\u0003s\n1d]3r\u001dVl'+\u00198hKNLenQ;se\u0016tGO\u00117pG.\u0004\u0003\"CAK\u0001\t\u0007I\u0011BAL\u0003U\u0011Gn\\2l\u0013\u0012$vnU3r\u001dVl'+\u00198hKN,\"!!'\u0011\u0011\u0005m\u0015QUAU\u0003_k!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u000bG>t7-\u001e:sK:$(\u0002BAR\u0003\u0007\nA!\u001e;jY&!\u0011qUAO\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004/\u0006-\u0016bAAW1\ni1\u000b\u001e:fC6\u0014En\\2l\u0013\u0012\u00042A\\AY\u0013\r\t\u0019L\u0001\u0002\u0015'\u0016\fX/\u001a8dK:+XNY3s%\u0006tw-Z:\t\u0011\u0005]\u0006\u0001)A\u0005\u00033\u000baC\u00197pG.LE\rV8TKFtU/\u001c*b]\u001e,7\u000f\t\u0005\n\u0003w\u0003\u0001\u0019!C\u0005\u0003{\u000b1c[5oKNL7o\u00115fG.\u0004x.\u001b8uKJ,\"!a0\u0011\u00079\f\t-C\u0002\u0002D\n\u00111cS5oKNL7o\u00115fG.\u0004x.\u001b8uKJD\u0011\"a2\u0001\u0001\u0004%I!!3\u0002/-Lg.Z:jg\u000eCWmY6q_&tG/\u001a:`I\u0015\fH\u0003BA\u0004\u0003\u0017D!\"a\u0004\u0002F\u0006\u0005\t\u0019AA`\u0011!\ty\r\u0001Q!\n\u0005}\u0016\u0001F6j]\u0016\u001c\u0018n]\"iK\u000e\\\u0007o\\5oi\u0016\u0014\b\u0005\u000b\u0003\u0002N\u0006]\u0001\"CAk\u0001\t\u0007I\u0011BAl\u0003m\u0019\b.\u0019:e\u0013\u0012$v\u000eT1uKN$8\u000b^8sK\u0012\u001cV-\u001d(v[V\u0011\u0011\u0011\u001c\t\u0007\u00037\u000b)\u000b\f\u0017\t\u0011\u0005u\u0007\u0001)A\u0005\u00033\fAd\u001d5be\u0012LE\rV8MCR,7\u000f^*u_J,GmU3r\u001dVl\u0007\u0005C\u0004\u0002b\u0002!\t%a9\u0002\u000f=t7\u000b^1siR\u0011\u0011q\u0001\u0005\b\u0003O\u0004A\u0011IAr\u0003\u0019ygn\u0015;pa\"A\u00111\u001e\u0001\u0005\u0002\t\ti/\u0001\u0006bI\u0012\u0014VmY8sIN$b!a\u0002\u0002p\u0006M\bbBAy\u0003S\u0004\r\u0001L\u0001\bg\"\f'\u000fZ%e\u0011!\t)0!;A\u0002\u0005]\u0018a\u0002:fG>\u0014Hm\u001d\t\u0006\u0003s\fYPY\u0007\u0003\u0003CKA!!@\u0002\"\n!A*[:u\u0011!\u0011\t\u0001\u0001C\u0001\u0005\t\r\u0011aG4fi2\u000bG/Z:u'\u0016\fh*^7U_\u000eCWmY6q_&tG\u000f\u0006\u0003\u0003\u0006\t\u001d\u0001cA\u000elY!9\u0011\u0011_A\u0000\u0001\u0004a\u0003b\u0002B\u0006\u0001\u0011\u0005!QB\u0001\u0010g\u0016$8\t[3dWB|\u0017N\u001c;feR1\u0011q\u0001B\b\u0005#Aq!!=\u0003\n\u0001\u0007A\u0006\u0003\u0005\u0003\u0014\t%\u0001\u0019\u0001B\u000b\u00031\u0019\u0007.Z2la>Lg\u000e^3s!\u0011\u00119B!\b\u000e\u0005\te!b\u0001B\u000e\u0003\u0006Q\u0011N\u001c;fe\u001a\f7-Z:\n\t\t}!\u0011\u0004\u0002\u001d\u0013J+7m\u001c:e!J|7-Z:t_J\u001c\u0005.Z2la>Lg\u000e^3s\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005K\t!C]3n_Z,7\t[3dWB|\u0017N\u001c;feR1\u0011q\u0001B\u0014\u0005SAq!!=\u0003\"\u0001\u0007A\u0006\u0003\u0005\u0003\u0014\t\u0005\u0002\u0019\u0001B\u000b\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_\t!C]3nK6\u0014WM]!eI\u0016$'+\u00198hKR!\u0011q\u0001B\u0019\u0011!\u0011\u0019Da\u000bA\u0002\u0005%\u0015!\u0002:b]\u001e,\u0007b\u0002B\u001c\u0001\u0011%!\u0011H\u0001\u001eM&t\u0017\r\\5{KJ\u000bgnZ3t\r>\u00148)\u001e:sK:$(\t\\8dWR!\u0011q\u0001B\u001e\u0011!\u0011iD!\u000eA\u0002\u0005%\u0016a\u00022m_\u000e\\\u0017\n\u001a\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003Q\u0019Ho\u001c:f\u00052|7m[,ji\"\u0014\u0016M\\4fgR1\u0011q\u0001B#\u0005\u000fB\u0001B!\u0010\u0003@\u0001\u0007\u0011\u0011\u0016\u0005\t\u0005\u0013\u0012y\u00041\u0001\u0003L\u0005Y\u0011M\u001d:bs\n+hMZ3s!\u0015\tY(!\"\u0015\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\nQD]3t_24X-Q,T\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM\u001d\u000b\u0003\u0005'\u0002BA!\u0016\u0003\\5\u0011!q\u000b\u0006\u0004\u000532\u0015\u0001B1vi\"LAA!\u0018\u0003X\t1\u0012iV*De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'O\u0002\u0004\u0003b\u0001!!1\r\u0002\u0016\u000f\u0016tWM]1uK\u0012\u0014En\\2l\u0011\u0006tG\r\\3s'\u0019\u0011yF!\u001a\u0003lA\u00191Da\u001a\n\u0007\t%DD\u0001\u0004B]f\u0014VM\u001a\t\u0004\u001f\t5\u0014b\u0001B8!\t1\"\t\\8dW\u001e+g.\u001a:bi>\u0014H*[:uK:,'\u000fC\u0004s\u0005?\"\tAa\u001d\u0015\u0005\tU\u0004\u0003\u0002B<\u0005?j\u0011\u0001\u0001\u0005\t\u0005w\u0012y\u0006\"\u0001\u0003~\u0005IqN\\!eI\u0012\u000bG/\u0019\u000b\u0007\u0003\u000f\u0011yHa!\t\u000f\t\u0005%\u0011\u0010a\u0001A\u0005!A-\u0019;b\u0011\u001d\u0011)I!\u001fA\u0002\u0001\n\u0001\"\\3uC\u0012\fG/\u0019\u0005\t\u0005\u0013\u0013y\u0006\"\u0001\u0003\f\u0006yqN\\$f]\u0016\u0014\u0018\r^3CY>\u001c7\u000e\u0006\u0003\u0002\b\t5\u0005\u0002\u0003B\u001f\u0005\u000f\u0003\r!!+\t\u0011\tE%q\fC\u0001\u0005'\u000b1b\u001c8QkND'\t\\8dWR1\u0011q\u0001BK\u0005/C\u0001B!\u0010\u0003\u0010\u0002\u0007\u0011\u0011\u0016\u0005\t\u0005\u0013\u0012y\t1\u0001\u0003\u001aB\"!1\u0014BP!\u0019\tY(!\"\u0003\u001eB\u0019QCa(\u0005\u0017\t\u0005&qSA\u0001\u0002\u0003\u0015\t!\u0007\u0002\u0004?\u0012\n\u0004\u0002\u0003BS\u0005?\"\tAa*\u0002\u000f=tWI\u001d:peR1\u0011q\u0001BU\u0005[CqAa+\u0003$\u0002\u0007A&A\u0004nKN\u001c\u0018mZ3\t\u0011\t=&1\u0015a\u0001\u0005c\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\tM&1\u0019\b\u0005\u0005k\u0013yL\u0004\u0003\u00038\nuVB\u0001B]\u0015\r\u0011Y\fG\u0001\u0007yI|w\u000e\u001e \n\u0003uI1A!1\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LAA!2\u0003H\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005\u0003d\u0002")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final Option<SerializableAWSCredentials> awsCredentialsOption;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    public ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    public ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder().append((Object)Utils$.MODULE$.localHostName()).append((Object)":").append((Object)UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider awsCredProvider = this.resolveAWSCredentialsProvider();
        KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), awsCredProvider, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withInitialPositionInStream(this.initialPositionInStream).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.restart("Error running the KCL worker in Receiver", e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kinesis Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId())})));
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started receiver with workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void onStop() {
        if (this.workerThread() != null) {
            if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
            }
            this.workerThread().join();
            this.workerThread_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisReceiver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped receiver for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
        if (this.kinesisCheckpointer() != null) {
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        if (records.size() > 0) {
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.wrapRefArray((Object[])this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated block ", " has ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 179->192)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AWSCredentialsProvider resolveAWSCredentialsProvider() {
        Option<SerializableAWSCredentials> option;
        block4: {
            AWSCredentialsProvider aWSCredentialsProvider;
            block3: {
                block2: {
                    option = this.awsCredentialsOption;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    SerializableAWSCredentials awsCredentials = (SerializableAWSCredentials)some.x();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Using provided AWS credentials";
                        }
                    });
                    aWSCredentialsProvider = new AWSCredentialsProvider(this, awsCredentials){
                        private final SerializableAWSCredentials awsCredentials$1;

                        public AWSCredentials getCredentials() {
                            return this.awsCredentials$1;
                        }

                        public void refresh() {
                        }
                        {
                            this.awsCredentials$1 = awsCredentials$1;
                        }
                    };
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Using DefaultAWSCredentialsProviderChain";
                    }
                });
                aWSCredentialsProvider = new DefaultAWSCredentialsProviderChain();
            }
            return aWSCredentialsProvider;
        }
        throw new MatchError(option);
    }

    public KinesisReceiver(String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, Option<SerializableAWSCredentials> awsCredentialsOption) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.awsCredentialsOption = awsCredentialsOption;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    public class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

