/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisDataGenerator;
import org.apache.spark.streaming.kinesis.KinesisTestUtils$;
import org.apache.spark.streaming.kinesis.SimpleDataGenerator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!B\u0001\u0003\u0001\ta!\u0001E&j]\u0016\u001c\u0018n\u001d+fgR,F/\u001b7t\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\")!\u0004\u0001C\u00019\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0002\u0005\n1\"\u001a8ea>Lg\u000e^+sYV\t!\u0005\u0005\u0002$M9\u0011a\u0002J\u0005\u0003K=\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\u0019\u0019FO]5oO*\u0011Qe\u0004\u0005\u0007U\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u0019\u0015tG\r]8j]R,&\u000f\u001c\u0011\t\u000f1\u0002!\u0019!C\u0001[\u0005Q!/Z4j_:t\u0015-\\3\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\t1\fgn\u001a\u0006\u0002g\u0005!!.\u0019<b\u0013\t9\u0003\u0007\u0003\u00047\u0001\u0001\u0006IAL\u0001\fe\u0016<\u0017n\u001c8OC6,\u0007\u0005C\u00049\u0001\t\u0007I\u0011A\u001d\u0002!M$(/Z1n'\"\f'\u000fZ\"pk:$X#\u0001\u001e\u0011\u00059Y\u0014B\u0001\u001f\u0010\u0005\rIe\u000e\u001e\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001e\u0002#M$(/Z1n'\"\f'\u000fZ\"pk:$\b\u0005C\u0004A\u0001\t\u0007I\u0011B\u001d\u00025\r\u0014X-\u0019;f'R\u0014X-Y7US6,w.\u001e;TK\u000e|g\u000eZ:\t\r\t\u0003\u0001\u0015!\u0003;\u0003m\u0019'/Z1uKN#(/Z1n)&lWm\\;u'\u0016\u001cwN\u001c3tA!9A\t\u0001b\u0001\n\u0013I\u0014!\b3fg\u000e\u0014\u0018NY3TiJ,\u0017-\u001c)pY2$\u0016.\\3TK\u000e|g\u000eZ:\t\r\u0019\u0003\u0001\u0015!\u0003;\u0003y!Wm]2sS\n,7\u000b\u001e:fC6\u0004v\u000e\u001c7US6,7+Z2p]\u0012\u001c\b\u0005C\u0004I\u0001\u0001\u0007I\u0011B%\u0002\u001bM$(/Z1n\u0007J,\u0017\r^3e+\u0005Q\u0005C\u0001\bL\u0013\tauBA\u0004C_>dW-\u00198\t\u000f9\u0003\u0001\u0019!C\u0005\u001f\u0006\t2\u000f\u001e:fC6\u001c%/Z1uK\u0012|F%Z9\u0015\u0005A\u001b\u0006C\u0001\bR\u0013\t\u0011vB\u0001\u0003V]&$\bb\u0002+N\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\n\u0004B\u0002,\u0001A\u0003&!*\u0001\btiJ,\u0017-\\\"sK\u0006$X\r\u001a\u0011)\u0005UC\u0006C\u0001\bZ\u0013\tQvB\u0001\u0005w_2\fG/\u001b7f\u0011%a\u0006\u00011AA\u0002\u0013%\u0011%A\u0006`gR\u0014X-Y7OC6,\u0007\"\u00030\u0001\u0001\u0004\u0005\r\u0011\"\u0003`\u0003=y6\u000f\u001e:fC6t\u0015-\\3`I\u0015\fHC\u0001)a\u0011\u001d!V,!AA\u0002\tBaA\u0019\u0001!B\u0013\u0011\u0013\u0001D0tiJ,\u0017-\u001c(b[\u0016\u0004\u0003FA1Y\u0011!)\u0007\u0001#b\u0001\n#1\u0017!D6j]\u0016\u001c\u0018n]\"mS\u0016tG/F\u0001h!\tA\u0007/D\u0001j\u0015\t\u0019!N\u0003\u0002lY\u0006A1/\u001a:wS\u000e,7O\u0003\u0002n]\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0002_\u0006\u00191m\\7\n\u0005EL'aE!nCj|gnS5oKNL7o\u00117jK:$\b\u0002C:\u0001\u0011\u0003\u0005\u000b\u0015B4\u0002\u001d-Lg.Z:jg\u000ec\u0017.\u001a8uA!AQ\u000f\u0001EC\u0002\u0013%a/\u0001\u0005es:\fWn\u001c#C+\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003!!wnY;nK:$(B\u0001?k\u0003)!\u0017P\\1n_\u0012\u0014gOM\u0005\u0003}f\u0014\u0001\u0002R=oC6|GI\u0011\u0005\n\u0003\u0003\u0001\u0001\u0012!Q!\n]\f\u0011\u0002Z=oC6|GI\u0011\u0011\t\u000f\u0005\u0015\u0001\u0001\"\u0005\u0002\b\u0005Yq-\u001a;Qe>$WoY3s)\u0011\tI!a\u0004\u0011\u0007y\tY!C\u0002\u0002\u000e\t\u0011AcS5oKNL7\u000fR1uC\u001e+g.\u001a:bi>\u0014\bbBA\t\u0003\u0007\u0001\rAS\u0001\nC\u001e<'/Z4bi\u0016Da!!\u0006\u0001\t\u0003\t\u0013AC:ue\u0016\fWNT1nK\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011\u0001D2sK\u0006$Xm\u0015;sK\u0006lG#\u0001)\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005A\u0001/^:i\t\u0006$\u0018\r\u0006\u0004\u0002$\u0005\u001d\u0013Q\n\t\u0007G\u0005\u0015\"%!\u000b\n\u0007\u0005\u001d\u0002FA\u0002NCB\u0004b!a\u000b\u0002<\u0005\u0005c\u0002BA\u0017\u0003oqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gY\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\tIdD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0007M+\u0017OC\u0002\u0002:=\u0001RADA\"u\tJ1!!\u0012\u0010\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011JA\u000f\u0001\u0004\tY%\u0001\u0005uKN$H)\u0019;b!\u0015\tY#a\u000f;\u0011\u001d\t\t\"!\bA\u0002)Cq!a\b\u0001\t\u0003\t\t\u0006F\u0002Q\u0003'B\u0001\"!\u0013\u0002P\u0001\u0007\u0011Q\u000b\t\u0006\u0003/\niFO\u0007\u0003\u00033R1!a\u00173\u0003\u0011)H/\u001b7\n\t\u0005}\u0013\u0011\f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002d\u0001!\t!a\u0007\u0002\u0019\u0011,G.\u001a;f'R\u0014X-Y7\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u0005\u0019B-\u001a7fi\u0016$\u0015P\\1n_\u0012\u0013E+\u00192mKR\u0019\u0001+a\u001b\t\u000f\u00055\u0014Q\ra\u0001E\u0005IA/\u00192mK:\u000bW.\u001a\u0005\b\u0003c\u0002A\u0011BA:\u00039!Wm]2sS\n,7\u000b\u001e:fC6$B!!\u001e\u0002\bB)a\"a\u001e\u0002|%\u0019\u0011\u0011P\b\u0003\r=\u0003H/[8o!\u0011\ti(a!\u000e\u0005\u0005}$bAAAS\u0006)Qn\u001c3fY&!\u0011QQA@\u0005E\u0019FO]3b[\u0012+7o\u0019:jaRLwN\u001c\u0005\b\u0003\u0013\u000by\u00071\u0001#\u0003Q\u0019HO]3b[:\u000bW.\u001a+p\t\u0016\u001c8M]5cK\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015!\u00074j]\u0012tuN\\#ySN$XM\u001c;TiJ,\u0017-\u001c(b[\u0016$\u0012A\t\u0005\b\u0003'\u0003A\u0011BAK\u0003]9\u0018-\u001b;G_J\u001cFO]3b[R{')Z!di&4X\rF\u0002Q\u0003/Cq!!'\u0002\u0012\u0002\u0007!%A\ntiJ,\u0017-\u001c(b[\u0016$vnV1ji\u001a{'o\u0002\u0005\u0002\u001e\nA\tAAAP\u0003AY\u0015N\\3tSN$Vm\u001d;Vi&d7\u000fE\u0002\u001f\u0003C3q!\u0001\u0002\t\u0002\t\t\u0019kE\u0002\u0002\"6AqAGAQ\t\u0003\t9\u000b\u0006\u0002\u0002 \"I\u00111VAQ\u0005\u0004%\t!L\u0001\u001bK:4h+\u0019:OC6,gi\u001c:F]\u0006\u0014G.\u001b8h)\u0016\u001cHo\u001d\u0005\t\u0003_\u000b\t\u000b)A\u0005]\u0005YRM\u001c<WCJt\u0015-\\3G_J,e.\u00192mS:<G+Z:ug\u0002B\u0011\"a-\u0002\"\n\u0007I\u0011A\u0017\u0002+\u0015tGMV1s\u001d\u0006lWMR8s\u000b:$\u0007o\\5oi\"A\u0011qWAQA\u0003%a&\u0001\ff]\u00124\u0016M\u001d(b[\u00164uN]#oIB|\u0017N\u001c;!\u0011%\tY,!)C\u0002\u0013\u0005Q&\u0001\neK\u001a\fW\u000f\u001c;F]\u0012\u0004x.\u001b8u+Jd\u0007\u0002CA`\u0003C\u0003\u000b\u0011\u0002\u0018\u0002'\u0011,g-Y;mi\u0016sG\r]8j]R,&\u000f\u001c\u0011\t\u0015\u0005\r\u0017\u0011\u0015EC\u0002\u0013\u0005\u0011*\u0001\btQ>,H\u000e\u001a*v]R+7\u000f^:\t\u0015\u0005\u001d\u0017\u0011\u0015E\u0001B\u0003&!*A\btQ>,H\u000e\u001a*v]R+7\u000f^:!\u0011%\u0001\u0013\u0011\u0015EC\u0002\u0013\u0005\u0011\u0005C\u0005+\u0003CC\t\u0011)Q\u0005E!9\u0011qZAQ\t\u0003I\u0015aF5t\u0003^\u001b6I]3eK:$\u0018.\u00197t!J,7/\u001a8u\u0011!\t\u0019.!)\u0005\u0002\u0005U\u0017!E4fi\u0006;6k\u0011:fI\u0016tG/[1mgR\u0011\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c7\u0002\t\u0005,H\u000f[\u0005\u0005\u0003C\fYN\u0001\bB/N\u001b%/\u001a3f]RL\u0017\r\\:")
public class KinesisTestUtils
implements Logging {
    private final String endpointUrl;
    private final String regionName;
    private final int streamShardCount;
    private final int createStreamTimeoutSeconds;
    private final int describeStreamPollTimeSeconds;
    private volatile boolean streamCreated;
    private volatile String org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName;
    private AmazonKinesisClient kinesisClient;
    private DynamoDB dynamoDB;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static AWSCredentials getAWSCredentials() {
        return KinesisTestUtils$.MODULE$.getAWSCredentials();
    }

    public static boolean isAWSCredentialsPresent() {
        return KinesisTestUtils$.MODULE$.isAWSCredentialsPresent();
    }

    public static boolean shouldRunTests() {
        return KinesisTestUtils$.MODULE$.shouldRunTests();
    }

    public static String defaultEndpointUrl() {
        return KinesisTestUtils$.MODULE$.defaultEndpointUrl();
    }

    public static String endVarNameForEndpoint() {
        return KinesisTestUtils$.MODULE$.endVarNameForEndpoint();
    }

    public static String envVarNameForEnablingTests() {
        return KinesisTestUtils$.MODULE$.envVarNameForEnablingTests();
    }

    /*
     * WARNING - void declaration
     */
    private AmazonKinesisClient kinesisClient$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                AmazonKinesisClient client = new AmazonKinesisClient(KinesisTestUtils$.MODULE$.getAWSCredentials());
                client.setEndpoint(this.endpointUrl());
                this.kinesisClient = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.kinesisClient;
        }
    }

    private DynamoDB dynamoDB$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                AmazonDynamoDBClient dynamoDBClient = new AmazonDynamoDBClient(new DefaultAWSCredentialsProviderChain());
                dynamoDBClient.setRegion(RegionUtils.getRegion(this.regionName()));
                this.dynamoDB = new DynamoDB(dynamoDBClient);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dynamoDB;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public int streamShardCount() {
        return this.streamShardCount;
    }

    private int createStreamTimeoutSeconds() {
        return this.createStreamTimeoutSeconds;
    }

    private int describeStreamPollTimeSeconds() {
        return this.describeStreamPollTimeSeconds;
    }

    private boolean streamCreated() {
        return this.streamCreated;
    }

    private void streamCreated_$eq(boolean x$1) {
        this.streamCreated = x$1;
    }

    public String org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName() {
        return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName;
    }

    private void org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName = x$1;
    }

    public AmazonKinesisClient kinesisClient() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.kinesisClient$lzycompute() : this.kinesisClient;
    }

    private DynamoDB dynamoDB() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dynamoDB$lzycompute() : this.dynamoDB;
    }

    public KinesisDataGenerator getProducer(boolean aggregate) {
        if (aggregate) {
            throw new UnsupportedOperationException("Aggregation is not supported through this code path");
        }
        return new SimpleDataGenerator(this.kinesisClient());
    }

    public String streamName() {
        Predef$.MODULE$.require(this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream not yet created, call createStream() to create one";
            }
        });
        return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName();
    }

    public void createStream() {
        Predef$.MODULE$.require(!this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream already created";
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName_$eq(this.findNonExistentStreamName());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CreateStreamRequest createStreamRequest = new CreateStreamRequest();
        createStreamRequest.setStreamName(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        createStreamRequest.setShardCount(Predef$.MODULE$.int2Integer(2));
        this.kinesisClient().createStream(createStreamRequest);
        this.waitForStreamToBeActive(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        this.streamCreated_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Map<String, Seq<Tuple2<Object, String>>> pushData(Seq<Object> testData, boolean aggregate) {
        Predef$.MODULE$.require(this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream not yet created, call createStream() to create one";
            }
        });
        KinesisDataGenerator producer = this.getProducer(aggregate);
        Map<String, Seq<Tuple2<Object, String>>> shardIdToSeqNumbers = producer.sendData(this.streamName(), testData);
        this.logInfo((Function0<String>)new Serializable(this, testData, shardIdToSeqNumbers){
            public static final long serialVersionUID = 0L;
            private final Seq testData$1;
            private final Map shardIdToSeqNumbers$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed ", ":\\n\\t ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testData$1, this.shardIdToSeqNumbers$1.mkString("\n\t")}));
            }
            {
                this.testData$1 = testData$1;
                this.shardIdToSeqNumbers$1 = shardIdToSeqNumbers$1;
            }
        });
        return shardIdToSeqNumbers.toMap(Predef$.MODULE$.$conforms());
    }

    public void pushData(List<Object> testData) {
        this.pushData((Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(testData).asScala()), false);
    }

    public void deleteStream() {
        try {
            if (this.streamCreated()) {
                this.kinesisClient().deleteStream(this.streamName());
            }
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisTestUtils $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.streamName()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void deleteDynamoDBTable(String tableName) {
        try {
            Table table = this.dynamoDB().getTable(tableName);
            table.delete();
            table.waitForDelete();
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this, tableName){
                public static final long serialVersionUID = 0L;
                private final String tableName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete DynamoDB table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1}));
                }
                {
                    this.tableName$1 = tableName$1;
                }
            });
        }
    }

    private Option<StreamDescription> describeStream(String streamNameToDescribe) {
        None$ none$;
        try {
            DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest().withStreamName(streamNameToDescribe);
            StreamDescription desc = this.kinesisClient().describeStream(describeStreamRequest).getStreamDescription();
            none$ = new Some((Object)desc);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private String findNonExistentStreamName() {
        void var1_1;
        String testStreamName = null;
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
        } while (this.describeStream(testStreamName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KinesisTestUtils-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)package$.MODULE$.abs(Random$.MODULE$.nextLong()))}))).nonEmpty());
        return var1_1;
    }

    private void waitForStreamToBeActive(String streamNameToWaitFor) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startTime = System.currentTimeMillis();
                long endTime = startTime + TimeUnit.SECONDS.toMillis(this.createStreamTimeoutSeconds());
                while (System.currentTimeMillis() < endTime) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
                    this.describeStream(streamNameToWaitFor).foreach((Function1)new Serializable(this, object){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KinesisTestUtils $outer;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(StreamDescription description) {
                            String streamStatus = description.getStreamStatus();
                            this.$outer.logDebug((Function0<String>)new Serializable(this, streamStatus){
                                public static final long serialVersionUID = 0L;
                                private final String streamStatus$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t- current state: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamStatus$1}));
                                }
                                {
                                    this.streamStatus$1 = streamStatus$1;
                                }
                            });
                            if ("ACTIVE".equals(streamStatus)) {
                                throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                Predef$.MODULE$.require(false, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KinesisTestUtils $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stream ", " never became active"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.streamName()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public KinesisTestUtils() {
        Logging.class.$init$((Logging)this);
        this.endpointUrl = KinesisTestUtils$.MODULE$.endpointUrl();
        this.regionName = RegionUtils.getRegionByEndpoint(this.endpointUrl()).getName();
        this.streamShardCount = 2;
        this.createStreamTimeoutSeconds = 300;
        this.describeStreamPollTimeSeconds = 1;
        this.streamCreated = false;
    }
}

