/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisUtils$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0005\u001b\tA2*\u001b8fg&\u001cX\u000b^5mgBKH\u000f[8o\u0011\u0016d\u0007/\u001a:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u00025\u001d,G/\u00138ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7\u0015\u0005qi\u0003CA\u000f,\u001b\u0005q\"BA\u0010!\u0003\u00199xN]6fe*\u0011\u0011EI\u0001\u0004Y&\u0014'BA\u0012%\u00035\u0019G.[3oi2L'M]1ss*\u00111!\n\u0006\u0003M\u001d\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003Q%\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003)\n1aY8n\u0013\tacDA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\")a&\u0007a\u0001_\u00059\u0012N\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\t\u0003\u001fAJ!!\r\t\u0003\u0007%sG\u000fC\u00034\u0001\u0011\u0005A'\u0001\u0007de\u0016\fG/Z*ue\u0016\fW\u000eF\u00066\u0007\"\u000b6+V,Y=\u001aD\u0007c\u0001\u001c<{5\tqG\u0003\u00029s\u0005!!.\u0019<b\u0015\tQD!A\u0002ba&L!\u0001P\u001c\u00031)\u000bg/\u0019*fG\u0016Lg/\u001a:J]B,H\u000fR*ue\u0016\fW\u000eE\u0002\u0010}\u0001K!a\u0010\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=\t\u0015B\u0001\"\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u0011\u0013\u0004\u0019A#\u0002\t)\u001c8o\u0019\t\u0003m\u0019K!aR\u001c\u0003))\u000bg/Y*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u0015I%\u00071\u0001K\u00039Y\u0017N\\3tSN\f\u0005\u000f\u001d(b[\u0016\u0004\"a\u0013(\u000f\u0005=a\u0015BA'\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\u0003\u0002\"\u0002*3\u0001\u0004Q\u0015AC:ue\u0016\fWNT1nK\")AK\ra\u0001\u0015\u0006YQM\u001c3q_&tG/\u0016:m\u0011\u00151&\u00071\u0001K\u0003)\u0011XmZ5p]:\u000bW.\u001a\u0005\u0006]I\u0002\ra\f\u0005\u00063J\u0002\rAW\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0005\u0002\\96\tA!\u0003\u0002^\t\tAA)\u001e:bi&|g\u000eC\u0003`e\u0001\u0007\u0001-\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0002bI6\t!M\u0003\u0002d\r\u000591\u000f^8sC\u001e,\u0017BA3c\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u00159'\u00071\u0001K\u00039\two]!dG\u0016\u001c8oS3z\u0013\u0012DQ!\u001b\u001aA\u0002)\u000bA\"Y<t'\u0016\u001c'/\u001a;LKf\u0004")
public class KinesisUtilsPythonHelper {
    public InitialPositionInStream getInitialPositionInStream(int initialPositionInStream) {
        InitialPositionInStream initialPositionInStream2;
        int n = initialPositionInStream;
        switch (n) {
            default: {
                throw new IllegalArgumentException("Illegal InitialPositionInStream. Please use InitialPositionInStream.LATEST or InitialPositionInStream.TRIM_HORIZON");
            }
            case 1: {
                initialPositionInStream2 = InitialPositionInStream.TRIM_HORIZON;
                break;
            }
            case 0: {
                initialPositionInStream2 = InitialPositionInStream.LATEST;
            }
        }
        return initialPositionInStream2;
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, int initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        if (awsAccessKeyId == null && awsSecretKey != null) {
            throw new IllegalArgumentException("awsSecretKey is set but awsAccessKeyId is null");
        }
        if (awsAccessKeyId != null && awsSecretKey == null) {
            throw new IllegalArgumentException("awsAccessKeyId is set but awsSecretKey is null");
        }
        return awsAccessKeyId == null && awsSecretKey == null ? KinesisUtils$.MODULE$.createStream(jssc, kinesisAppName, streamName2, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel) : KinesisUtils$.MODULE$.createStream(jssc, kinesisAppName, streamName2, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey);
    }
}

