/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.ConfigurableCredentialManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001\u0011q!aE!N\u0007J,G-\u001a8uS\u0006d'+\u001a8fo\u0016\u0014(BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u0011I\u0018M\u001d8\u000b\u0005\u001dA\u0011A\u00023fa2|\u0017P\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005aA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005I1\u000f]1sW\u000e{gNZ\u0002\u0001!\ty\u0002%D\u0001\t\u0013\t\t\u0003BA\u0005Ta\u0006\u00148nQ8oM\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t\r|gN\u001a\u0006\u0003S)\ta\u0001[1e_>\u0004\u0018BA\u0016'\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"AQ\u0006\u0001B\u0001B\u0003%a&A\tde\u0016$WM\u001c;jC2l\u0015M\\1hKJ\u0004\"a\f\u0019\u000e\u0003\tI!!\r\u0002\u0003;\r{gNZ5hkJ\f'\r\\3De\u0016$WM\u001c;jC2l\u0015M\\1hKJDQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtD\u0003B\u001b7oa\u0002\"a\f\u0001\t\u000bq\u0011\u0004\u0019\u0001\u0010\t\u000b\r\u0012\u0004\u0019\u0001\u0013\t\u000b5\u0012\u0004\u0019\u0001\u0018\t\u000fi\u0002\u0001\u0019!C\u0005w\u0005IB.Y:u\u0007J,G-\u001a8uS\u0006d7OR5mKN+hMZ5y+\u0005a\u0004C\u0001\t>\u0013\tq\u0014CA\u0002J]RDq\u0001\u0011\u0001A\u0002\u0013%\u0011)A\u000fmCN$8I]3eK:$\u0018.\u00197t\r&dWmU;gM&Dx\fJ3r)\t\u0011U\t\u0005\u0002\u0011\u0007&\u0011A)\u0005\u0002\u0005+:LG\u000fC\u0004G\u007f\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013\u0007\u0003\u0004I\u0001\u0001\u0006K\u0001P\u0001\u001bY\u0006\u001cHo\u0011:fI\u0016tG/[1mg\u001aKG.Z*vM\u001aL\u0007\u0010\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0003E\u0019'/\u001a3f]RL\u0017\r\u001c*f]\u0016<XM]\u000b\u0002\u0019B\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\u000bG>t7-\u001e:sK:$(BA)S\u0003\u0011)H/\u001b7\u000b\u0003M\u000bAA[1wC&\u0011QK\u0014\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007BB,\u0001A\u0003%A*\u0001\nde\u0016$WM\u001c;jC2\u0014VM\\3xKJ\u0004\u0003bB-\u0001\u0005\u0004%IAW\u0001\u000bQ\u0006$wn\u001c9Vi&dW#A.\u0011\u0005qkV\"\u0001\u0003\n\u0005y#!aE-be:\u001c\u0006/\u0019:l\u0011\u0006$wn\u001c9Vi&d\u0007B\u00021\u0001A\u0003%1,A\u0006iC\u0012|w\u000e]+uS2\u0004\u0003b\u00022\u0001\u0005\u0004%IaY\u0001\u0010GJ,G-\u001a8uS\u0006d7OR5mKV\tA\r\u0005\u0002fQ:\u0011\u0001CZ\u0005\u0003OF\ta\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q-\u0005\u0005\u0007Y\u0002\u0001\u000b\u0011\u00023\u0002!\r\u0014X\rZ3oi&\fGn\u001d$jY\u0016\u0004\u0003b\u00028\u0001\u0005\u0004%IaO\u0001\u0010I\u0006L8\u000fV8LK\u0016\u0004h)\u001b7fg\"1\u0001\u000f\u0001Q\u0001\nq\n\u0001\u0003Z1zgR{7*Z3q\r&dWm\u001d\u0011\t\u000fI\u0004!\u0019!C\u0005w\u0005qa.^7GS2,7\u000fV8LK\u0016\u0004\bB\u0002;\u0001A\u0003%A(A\bok64\u0015\u000e\\3t)>\\U-\u001a9!\u0011\u001d1\bA1A\u0005\n]\fqB\u001a:fg\"D\u0015\rZ8pa\u000e{gNZ\u000b\u0002I!1\u0011\u0010\u0001Q\u0001\n\u0011\n\u0001C\u001a:fg\"D\u0015\rZ8pa\u000e{gN\u001a\u0011\t\u000fm\u0004\u0001\u0019!C\u0005y\u0006\tB/[7f\u001f\u001atU\r\u001f;SK:,w/\u00197\u0016\u0003u\u0004\"\u0001\u0005@\n\u0005}\f\"\u0001\u0002'p]\u001eD\u0011\"a\u0001\u0001\u0001\u0004%I!!\u0002\u0002+QLW.Z(g\u001d\u0016DHOU3oK^\fGn\u0018\u0013fcR\u0019!)a\u0002\t\u0011\u0019\u000b\t!!AA\u0002uDq!a\u0003\u0001A\u0003&Q0\u0001\nuS6,wJ\u001a(fqR\u0014VM\\3xC2\u0004\u0003\u0006BA\u0005\u0003\u001f\u00012\u0001EA\t\u0013\r\t\u0019\"\u0005\u0002\tm>d\u0017\r^5mK\"A\u0011q\u0003\u0001\u0005\u0002!\tI\"A\ftG\",G-\u001e7f\u0019><\u0017N\u001c$s_6\\U-\u001f;bER\t!\tC\u0004\u0002\u001e\u0001!I!!\u0007\u0002\u001f\rdW-\u00198va>cGMR5mKNDq!!\t\u0001\t\u0013\t\u0019#A\rxe&$XMT3x\u0007J,G-\u001a8uS\u0006d7\u000fV8I\t\u001a\u001bF#\u0002\"\u0002&\u0005%\u0002bBA\u0014\u0003?\u0001\r\u0001Z\u0001\naJLgnY5qC2Dq!a\u000b\u0002 \u0001\u0007A-\u0001\u0004lKf$\u0018M\u0019\u0005\b\u0003_\u0001A\u0011AA\r\u0003\u0011\u0019Ho\u001c9")
public class AMCredentialRenewer
implements Logging {
    private final SparkConf sparkConf;
    public final ConfigurableCredentialManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    private int org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix;
    private final ScheduledExecutorService org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer;
    private final YarnSparkHadoopUtil org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil;
    private final String credentialsFile;
    private final int daysToKeepFiles;
    private final int numFilesToKeep;
    private final Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf;
    private volatile long timeOfNextRenewal;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private int org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix = x$1;
    }

    public ScheduledExecutorService org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer;
    }

    public YarnSparkHadoopUtil org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil;
    }

    private String credentialsFile() {
        return this.credentialsFile;
    }

    private int daysToKeepFiles() {
        return this.daysToKeepFiles;
    }

    private int numFilesToKeep() {
        return this.numFilesToKeep;
    }

    public Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf;
    }

    private long timeOfNextRenewal() {
        return this.timeOfNextRenewal;
    }

    private void timeOfNextRenewal_$eq(long x$1) {
        this.timeOfNextRenewal = x$1;
    }

    public void scheduleLoginFromKeytab() {
        String principal = (String)((Option)this.sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).get();
        String keytab = (String)((Option)this.sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.KEYTAB())).get();
        Runnable credentialRenewerRunnable = new Runnable(this, principal, keytab){
            private final /* synthetic */ AMCredentialRenewer $outer;
            private final String principal$1;
            private final String keytab$1;

            public void run() {
                try {
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$writeNewCredentialsToHDFS(this.principal$1, this.keytab$1);
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$cleanupOldFiles();
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal$1(this);
                    return;
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Failed to write out new credentials to HDFS, will try again in an hour! If this happens too often tasks will fail.";
                        }
                    }, exception);
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer().schedule(this, 1L, TimeUnit.HOURS);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.keytab$1 = keytab$1;
            }
        };
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal$1(credentialRenewerRunnable);
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$cleanupOldFiles() {
        try {
            FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf());
            Path credentialsPath = new Path(this.credentialsFile());
            long thresholdTime = System.currentTimeMillis() - new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.daysToKeepFiles())).days().toMillis();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).dropRight(this.numFilesToKeep())).takeWhile((Function1)new Serializable(this, thresholdTime){
                public static final long serialVersionUID = 0L;
                private final long thresholdTime$1;

                public final boolean apply(FileStatus x$1) {
                    return x$1.getModificationTime() < this.thresholdTime$1;
                }
                {
                    this.thresholdTime$1 = thresholdTime$1;
                }
            })).foreach((Function1)new Serializable(this, remoteFs){
                public static final long serialVersionUID = 0L;
                private final FileSystem remoteFs$1;

                public final boolean apply(FileStatus x) {
                    return this.remoteFs$1.delete(x.getPath(), true);
                }
                {
                    this.remoteFs$1 = remoteFs$1;
                }
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while attempting to cleanup old credentials. If you are seeing many such warnings there may be an issue with your HDFS cluster.";
                }
            }, exception);
        }
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$writeNewCredentialsToHDFS(String principal, String keytab) {
        long l;
        this.logInfo((Function0<String>)new Serializable(this, principal){
            public static final long serialVersionUID = 0L;
            private final String principal$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to login to KDC using principal: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$2}));
            }
            {
                this.principal$2 = principal$2;
            }
        });
        UserGroupInformation keytabLoggedInUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Successfully logged into KDC.";
            }
        });
        Credentials tempCreds = keytabLoggedInUGI.getCredentials();
        Path credentialsPath = new Path(this.credentialsFile());
        Path dst = credentialsPath.getParent();
        LongRef nearestNextRenewalTime = new LongRef(Long.MAX_VALUE);
        keytabLoggedInUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(this, tempCreds, nearestNextRenewalTime){
            private final /* synthetic */ AMCredentialRenewer $outer;
            private final Credentials tempCreds$1;
            private final LongRef nearestNextRenewalTime$1;

            public Void run() {
                this.nearestNextRenewalTime$1.elem = this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager.obtainCredentials(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf(), this.tempCreds$1);
                return null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tempCreds$1 = tempCreds$1;
                this.nearestNextRenewalTime$1 = nearestNextRenewalTime$1;
            }
        });
        long currTime = System.currentTimeMillis();
        if (nearestNextRenewalTime.elem <= currTime) {
            this.logWarning((Function0<String>)new Serializable(this, nearestNextRenewalTime, currTime){
                public static final long serialVersionUID = 0L;
                private final LongRef nearestNextRenewalTime$1;
                private final long currTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Next credential renewal time (", ") is earlier than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.nearestNextRenewalTime$1.elem)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current time (", "), which is unexpected, please check your credential renewal "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.currTime$1)}))).append((Object)"related configurations in the target services.").toString();
                }
                {
                    this.nearestNextRenewalTime$1 = nearestNextRenewalTime$1;
                    this.currTime$1 = currTime$1;
                }
            });
            this.timeOfNextRenewal_$eq(currTime);
            l = currTime;
        } else {
            this.timeOfNextRenewal_$eq((long)((double)(nearestNextRenewalTime.elem - currTime) * 0.75 + (double)currTime));
            l = (long)((double)(nearestNextRenewalTime.elem - currTime) * 0.8 + (double)currTime);
        }
        long timeOfNextUpdate = l;
        UserGroupInformation.getCurrentUser().addCredentials(tempCreds);
        FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf());
        if (this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix() == 0) {
            Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AMCredentialRenewer $outer;

                public final void apply(FileStatus status) {
                    this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix_$eq(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().getSuffixForCredentialsPath(status.getPath()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        int nextSuffix = this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix() + 1;
        String tokenPathStr = new StringBuilder().append((Object)this.credentialsFile()).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()).append((Object)((Object)BoxesRunTime.boxToLong((long)timeOfNextUpdate)).toString()).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()).append((Object)BoxesRunTime.boxToInteger((int)nextSuffix)).toString();
        Path tokenPath = new Path(tokenPathStr);
        Path tempTokenPath = new Path(new StringBuilder().append((Object)tokenPathStr).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION()).toString());
        this.logInfo((Function0<String>)new Serializable(this, tempTokenPath){
            public static final long serialVersionUID = 0L;
            private final Path tempTokenPath$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Writing out delegation tokens to ").append((Object)this.tempTokenPath$1.toString()).toString();
            }
            {
                this.tempTokenPath$1 = tempTokenPath$1;
            }
        });
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        credentials.writeTokenStorageFile(tempTokenPath, this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf());
        this.logInfo((Function0<String>)new Serializable(this, tokenPathStr){
            public static final long serialVersionUID = 0L;
            private final String tokenPathStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation Tokens written out successfully. Renaming file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenPathStr$1}));
            }
            {
                this.tokenPathStr$1 = tokenPathStr$1;
            }
        });
        remoteFs.rename(tempTokenPath, tokenPath);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delegation token file rename complete.";
            }
        });
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix_$eq(nextSuffix);
    }

    public void stop() {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer().shutdown();
    }

    public final void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal$1(Runnable runnable) {
        long remainingTime = this.timeOfNextRenewal() - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Credentials have expired, creating new ones now.";
                }
            });
            runnable.run();
        } else {
            this.logInfo((Function0<String>)new Serializable(this, remainingTime){
                public static final long serialVersionUID = 0L;
                private final long remainingTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling login from keytab in ", " millis."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.remainingTime$1)}));
                }
                {
                    this.remainingTime$1 = remainingTime$1;
                }
            });
            this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer().schedule(runnable, remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public AMCredentialRenewer(SparkConf sparkConf, Configuration hadoopConf, ConfigurableCredentialManager credentialManager) {
        this.sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager = credentialManager;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$lastCredentialsFileSuffix = 0;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialRenewer = Executors.newSingleThreadScheduledExecutor(ThreadUtils$.MODULE$.namedThreadFactory("Credential Refresh Thread"));
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil = YarnSparkHadoopUtil$.MODULE$.get();
        this.credentialsFile = (String)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_PATH());
        this.daysToKeepFiles = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_MAX_RETENTION()));
        this.numFilesToKeep = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.CREDENTIAL_FILE_MAX_COUNT()));
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$freshHadoopConf = this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopUtil().getConfBypassingFSCache(hadoopConf, new Path(this.credentialsFile()).toUri().getScheme());
        this.timeOfNextRenewal = BoxesRunTime.unboxToLong((Object)sparkConf.get(package$.MODULE$.CREDENTIALS_RENEWAL_TIME()));
    }
}

