/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.ExecutorRunnable$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005md!B\u0001\u0003\u0001\ta!\u0001E#yK\u000e,Ho\u001c:Sk:t\u0017M\u00197f\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\nG>tG/Y5oKJ\u001c\u0001\u0001E\u0002\u000f;}I!AH\b\u0003\r=\u0003H/[8o!\t\u0001\u0003&D\u0001\"\u0015\t\u00113%A\u0004sK\u000e|'\u000fZ:\u000b\u0005\u0011*\u0013aA1qS*\u00111A\n\u0006\u0003O!\ta\u0001[1e_>\u0004\u0018BA\u0015\"\u0005%\u0019uN\u001c;bS:,'\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003\u0011\u0019wN\u001c4\u0011\u00055zS\"\u0001\u0018\u000b\u0005-*\u0013B\u0001\u0019/\u0005EI\u0016M\u001d8D_:4\u0017nZ;sCRLwN\u001c\u0005\te\u0001\u0011\t\u0011)A\u0005g\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003iUj\u0011AB\u0005\u0003m\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011a\u0002!\u0011!Q\u0001\ne\nQ\"\\1ti\u0016\u0014\u0018\t\u001a3sKN\u001c\bC\u0001\u001e>\u001d\tq1(\u0003\u0002=\u001f\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\tat\u0002\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003:\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005s\u0005A\u0001n\\:u]\u0006lW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u00039)\u00070Z2vi>\u0014X*Z7pef\u0004\"AD$\n\u0005!{!aA%oi\"A!\n\u0001B\u0001B\u0003%a)A\u0007fq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005s\u0005)\u0011\r\u001d9JI\"Aa\n\u0001B\u0001B\u0003%q*A\u0006tK\u000e,(/\u001b;z\u001b\u001e\u0014\bC\u0001\u001bQ\u0013\t\tfAA\bTK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s\u0011!\u0019\u0006A!A!\u0002\u0013!\u0016A\u00047pG\u0006d'+Z:pkJ\u001cWm\u001d\t\u0005uUKt+\u0003\u0002W\u007f\t\u0019Q*\u00199\u0011\u0005\u0001B\u0016BA-\"\u00055aunY1m%\u0016\u001cx.\u001e:dK\")1\f\u0001C\u00019\u00061A(\u001b8jiz\"B\"X0aC\n\u001cG-\u001a4hQ&\u0004\"A\u0018\u0001\u000e\u0003\tAQA\u0007.A\u0002qAQa\u000b.A\u00021BQA\r.A\u0002MBQ\u0001\u000f.A\u0002eBQ!\u0011.A\u0002eBQa\u0011.A\u0002eBQ!\u0012.A\u0002\u0019CQA\u0013.A\u0002\u0019CQ\u0001\u0014.A\u0002eBQA\u0014.A\u0002=CQa\u0015.A\u0002QCqa\u001b\u0001A\u0002\u0013\u0005A.A\u0002sa\u000e,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u0016\n1!\u001b9d\u0013\t\u0011xNA\u0004ZCJt'\u000bU\"\t\u000fQ\u0004\u0001\u0019!C\u0001k\u00069!\u000f]2`I\u0015\fHC\u0001<z!\tqq/\u0003\u0002y\u001f\t!QK\\5u\u0011\u001dQ8/!AA\u00025\f1\u0001\u001f\u00132\u0011\u0019a\b\u0001)Q\u0005[\u0006!!\u000f]2!\u0011%q\b\u00011AA\u0002\u0013\u0005q0\u0001\u0005o[\u000ec\u0017.\u001a8u+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005-QBAA\u0003\u0015\r!\u0013q\u0001\u0006\u0004\u0003\u0013)\u0013AB2mS\u0016tG/\u0003\u0003\u0002\u000e\u0005\u0015!\u0001\u0003(N\u00072LWM\u001c;\t\u0017\u0005E\u0001\u00011AA\u0002\u0013\u0005\u00111C\u0001\r]6\u001cE.[3oi~#S-\u001d\u000b\u0004m\u0006U\u0001\"\u0003>\u0002\u0010\u0005\u0005\t\u0019AA\u0001\u0011!\tI\u0002\u0001Q!\n\u0005\u0005\u0011!\u00038n\u00072LWM\u001c;!\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\t1A];o)\u00051\bbBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u0017Y\u0006,hn\u00195D_:$X\r\u001f;EK\n,x-\u00138g_R\t\u0011\bC\u0004\u0002*\u0001!\t!a\u000b\u0002\u001dM$\u0018M\u001d;D_:$\u0018-\u001b8feR\u0011\u0011Q\u0006\t\b\u0003_\tI$OA\u001e\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001B;uS2T!!a\u000e\u0002\t)\fg/Y\u0005\u0004-\u0006E\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\t\u0005\u0005\u0013QG\u0001\u0004]&|\u0017\u0002BA#\u0003\u007f\u0011!BQ=uK\n+hMZ3s\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\na\u0002\u001d:fa\u0006\u0014XmQ8n[\u0006tG\r\u0006\u0002\u0002NA)\u0011qJA0s9!\u0011\u0011KA.\u001d\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,7\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003;z\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003C\n\u0019G\u0001\u0003MSN$(bAA/\u001f!9\u0011q\r\u0001\u0005\n\u0005%\u0014A\u00059sKB\f'/Z#om&\u0014xN\\7f]R$\"!a\u001b\u0011\r\u00055\u0014qO\u001d:\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003kz\u0011AC2pY2,7\r^5p]&!\u0011\u0011PA8\u0005\u001dA\u0015m\u001d5NCB\u0004")
public class ExecutorRunnable
implements Logging {
    private final Option<Container> container;
    private final YarnConfiguration conf;
    public final SparkConf org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf;
    private final String masterAddress;
    private final String executorId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private YarnRPC rpc;
    private NMClient nmClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public void run() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Executor Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.conf);
        this.nmClient().start();
        this.startContainer();
    }

    public String launchContextDebugInfo() {
        List<String> commands = this.prepareCommand();
        HashMap<String, String> env = this.prepareEnvironment();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    |===============================================================================\n    |YARN executor launch context:\n    |  env:\n    |", "\n    |  command:\n    |    ", "\n    |\n    |  resources:\n    |", "\n    |==============================================================================="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)env.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", " -> ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(), commands.mkString(" \\ \n      "), ((TraversableOnce)this.localResources.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, LocalResource> x0$2) {
                Tuple2<String, LocalResource> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    LocalResource v = (LocalResource)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", " -> ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString()})))).stripMargin();
    }

    public Map<String, ByteBuffer> startContainer() {
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Map env = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.prepareEnvironment()).asJava();
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment(env);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand();
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString == null ? ByteBuffer.allocate(0) : JavaUtils.stringToBytes((String)secretString);
            ctx.setServiceData(Collections.singletonMap("spark_shuffle", secretBytes));
        }
        try {
            return this.nmClient().startContainer((Container)this.container.get(), ctx);
        }
        catch (Exception exception) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while starting container ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Container)this.container.get()).getId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname}))).toString(), (Throwable)exception);
        }
    }

    private List<String> prepareCommand() {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef prefixEnv = ObjectRef.create((Object)None$.MODULE$);
        String executorMemoryString = new StringBuilder().append(this.executorMemory).append((Object)"m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)executorMemoryString).toString());
        ((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        ((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).foreach((Function1)new Serializable(this, prefixEnv){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;
            private final ObjectRef prefixEnv$1;

            public final void apply(String p) {
                this.prefixEnv$1.elem = new Some((Object)Client$.MODULE$.getClusterPath(this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, Utils$.MODULE$.libraryPathEnvPrefix((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p})))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.prefixEnv$1 = prefixEnv$1;
            }
        });
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)new Path(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), "./tmp")).toString());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.getAll()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        YarnCommandBuilderUtils$.MODULE$.addPermGenSizeOpt((ListBuffer<String>)javaOpts);
        Seq userClassPath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Client$.MODULE$.getUserClasspath(this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf)).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;

            public final Seq<String> apply(URI uri) {
                String absPath = new File(uri.getPath()).isAbsolute() ? Client$.MODULE$.getClusterPath(this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, uri.getPath()) : Client$.MODULE$.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$(), uri.getPath()}));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--user-class-path", new StringBuilder().append((Object)"file:").append((Object)absPath).toString()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq();
        YarnSparkHadoopUtil$.MODULE$.addOutOfMemoryErrorArgument((ListBuffer<String>)javaOpts);
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable((Option)prefixEnv.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.JAVA_HOME)).append((Object)"/bin/java").toString(), "-server"})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", "--driver-url", this.masterAddress, "--executor-id", this.executorId, "--hostname", this.hostname, "--cores", ((Object)BoxesRunTime.boxToInteger((int)this.executorCores)).toString(), "--app-id", this.appId})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userClassPath, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1>", "/stdout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"<LOG_DIR>"})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2>", "/stderr"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"<LOG_DIR>"}))})), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment() {
        void var1_1;
        String yarnHttpPolicy;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.conf, this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.getExecutorEnv().foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        String string = yarnHttpPolicy = this.conf.get("yarn.http.policy", "HTTP_ONLY");
        String string2 = "HTTPS_ONLY";
        String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
        this.container.foreach((Function1)new Serializable(this, env, httpScheme){
            public static final long serialVersionUID = 0L;
            public final HashMap env$1;
            public final String httpScheme$1;

            public final void apply(Container c) {
                scala.sys.package$.MODULE$.env().get((Object)"SPARK_USER").foreach((Function1)new Serializable(this, c){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$prepareEnvironment$3 $outer;
                    private final Container c$1;

                    public final void apply(String user) {
                        String containerId = ConverterUtils.toString((ContainerId)this.c$1.getId());
                        String address = this.c$1.getNodeHttpAddress();
                        String baseUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "/node/containerlogs/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.httpScheme$1, address, containerId, user}));
                        this.$outer.env$1.update((Object)"SPARK_LOG_URL_STDERR", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stderr?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
                        this.$outer.env$1.update((Object)"SPARK_LOG_URL_STDOUT", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stdout?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                    }
                });
            }
            {
                this.env$1 = env$1;
                this.httpScheme$1 = httpScheme$1;
            }
        });
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("SPARK");
            }
        }).foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.env$1.update((Object)k, (Object)v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var1_1;
    }

    public ExecutorRunnable(Option<Container> container, YarnConfiguration conf, SparkConf sparkConf, String masterAddress, String executorId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources) {
        this.container = container;
        this.conf = conf;
        this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.executorId = executorId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        Logging.class.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
    }
}

