/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.UnknownServiceException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.BufferedIoOutputStream;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AsyncCommand;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.AbstractSftpSubsystemHelper;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpErrorStatusDataHandler;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystem
extends AbstractSftpSubsystemHelper
implements Command,
Runnable,
SessionAware,
FileSystemAware,
ExecutorServiceCarrier,
AsyncCommand,
ChannelSessionAware,
ChannelDataReceiver {
    public static final String MAX_OPEN_HANDLES_PER_SESSION = "max-open-handles-per-session";
    public static final int DEFAULT_MAX_OPEN_HANDLES = Integer.MAX_VALUE;
    public static final String FILE_HANDLE_SIZE = "sftp-handle-size";
    public static final int MIN_FILE_HANDLE_SIZE = 4;
    public static final int DEFAULT_FILE_HANDLE_SIZE = 16;
    public static final int MAX_FILE_HANDLE_SIZE = 64;
    public static final String MAX_FILE_HANDLE_RAND_ROUNDS = "sftp-handle-rand-max-rounds";
    public static final int MIN_FILE_HANDLE_ROUNDS = 1;
    public static final int DEFAULT_FILE_HANDLE_ROUNDS = 4;
    public static final int MAX_FILE_HANDLE_ROUNDS = 64;
    public static final String MAX_READDIR_DATA_SIZE_PROP = "sftp-max-readdir-data-size";
    public static final int DEFAULT_MAX_READDIR_DATA_SIZE = 16384;
    protected static final Buffer CLOSE = new ByteArrayBuffer(null, 0, 0);
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicLong requestsCount = new AtomicLong(0L);
    protected final Map<String, byte[]> extensions = new TreeMap(Comparator.naturalOrder());
    protected final Map<String, Handle> handles = new ConcurrentHashMap<String, Handle>();
    protected final Buffer buffer = new ByteArrayBuffer(1024);
    protected final BlockingQueue<Buffer> requests = new LinkedBlockingQueue<Buffer>();
    protected ExitCallback callback;
    protected IoOutputStream out;
    protected IoOutputStream err;
    protected Environment env;
    protected Random randomizer;
    protected int fileHandleSize = 16;
    protected int maxFileHandleRounds = 4;
    protected Future<?> pendingFuture;
    protected byte[] workBuf = new byte[Math.max(16, 4)];
    protected FileSystem fileSystem = FileSystems.getDefault();
    protected Path defaultDir = this.fileSystem.getPath("", new String[0]).toAbsolutePath().normalize();
    protected int version;
    protected ServerSession serverSession;
    protected ChannelSession channelSession;
    protected CloseableExecutorService executorService;

    public SftpSubsystem(CloseableExecutorService executorService, UnsupportedAttributePolicy policy, SftpFileSystemAccessor accessor, SftpErrorStatusDataHandler errorStatusDataHandler) {
        super(policy, accessor, errorStatusDataHandler);
        this.executorService = executorService == null ? ThreadUtils.newSingleThreadExecutor((String)this.getClass().getSimpleName()) : executorService;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Path getDefaultDirectory() {
        return this.defaultDir;
    }

    public CloseableExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setSession(ServerSession session) {
        this.serverSession = Objects.requireNonNull(session, "No session");
        ServerFactoryManager manager = session.getFactoryManager();
        Factory factory = manager.getRandomFactory();
        this.randomizer = (Random)factory.create();
        this.fileHandleSize = session.getIntProperty(FILE_HANDLE_SIZE, 16);
        ValidateUtils.checkTrue((this.fileHandleSize >= 4 ? 1 : 0) != 0, (String)"File handle size too small: %d", (long)this.fileHandleSize);
        ValidateUtils.checkTrue((this.fileHandleSize <= 64 ? 1 : 0) != 0, (String)"File handle size too big: %d", (long)this.fileHandleSize);
        this.maxFileHandleRounds = session.getIntProperty(MAX_FILE_HANDLE_RAND_ROUNDS, 4);
        ValidateUtils.checkTrue((this.maxFileHandleRounds >= 1 ? 1 : 0) != 0, (String)"File handle rounds too small: %d", (long)this.maxFileHandleRounds);
        ValidateUtils.checkTrue((this.maxFileHandleRounds <= 64 ? 1 : 0) != 0, (String)"File handle rounds too big: %d", (long)this.maxFileHandleRounds);
        if (this.workBuf.length < this.fileHandleSize) {
            this.workBuf = new byte[this.fileHandleSize];
        }
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public void setChannelSession(ChannelSession session) {
        this.channelSession = session;
        session.setDataReceiver((ChannelDataReceiver)this);
    }

    public void setFileSystem(FileSystem fileSystem) {
        if (fileSystem != this.fileSystem) {
            this.fileSystem = fileSystem;
            this.defaultDir = fileSystem.getPath("", new String[0]).toAbsolutePath().normalize();
        }
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setInputStream(InputStream in) {
    }

    public void setOutputStream(OutputStream out) {
    }

    public void setErrorStream(OutputStream err) {
    }

    public void setIoInputStream(IoInputStream in) {
    }

    public void setIoOutputStream(IoOutputStream out) {
        this.out = new BufferedIoOutputStream((Object)"sftp out buffer", out);
    }

    public void setIoErrorStream(IoOutputStream err) {
        this.err = err;
    }

    public void start(Environment env) throws IOException {
        this.env = env;
        try {
            CloseableExecutorService executor = this.getExecutorService();
            this.pendingFuture = executor.submit((Runnable)this);
        }
        catch (RuntimeException e) {
            this.log.error("Failed (" + e.getClass().getSimpleName() + ") to start command: " + e.toString(), (Throwable)e);
            throw new IOException(e);
        }
    }

    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        this.buffer.compact();
        this.buffer.putRawBytes(buf, start, len);
        while (this.buffer.available() >= 4) {
            int rpos = this.buffer.rpos();
            int msglen = this.buffer.getInt();
            if (this.buffer.available() >= msglen) {
                ByteArrayBuffer b = new ByteArrayBuffer(msglen + 4 + 64, false);
                b.putInt((long)msglen);
                b.putRawBytes(this.buffer.array(), this.buffer.rpos(), msglen);
                this.requests.add((Buffer)b);
                this.buffer.rpos(rpos + msglen + 4);
                continue;
            }
            this.buffer.rpos(rpos);
            break;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Buffer buffer;
            while ((buffer = this.requests.take()) != CLOSE) {
                int len = buffer.available();
                this.process(buffer);
                Window localWindow = this.channelSession.getLocalWindow();
                localWindow.consumeAndCheck((long)len);
            }
        }
        catch (Throwable t) {
            if (!this.closed.get()) {
                ServerSession session = this.getServerSession();
                this.log.error("run({}) {} caught in SFTP subsystem: {}", new Object[]{session, t.getClass().getSimpleName(), t.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.debug("run(" + session + ") caught exception details", t);
                }
            }
        }
        finally {
            this.closeAllHandles();
            this.callback.onExit(0);
        }
    }

    public void close() throws IOException {
        this.requests.clear();
        this.requests.add(CLOSE);
    }

    @Override
    protected void doProcess(Buffer buffer, int length, int type, int id) throws IOException {
        super.doProcess(buffer, length, type, id);
        if (type != 1) {
            this.requestsCount.incrementAndGet();
        }
    }

    @Override
    protected void createLink(int id, String existingPath, String linkPath, boolean symLink) throws IOException {
        Path link = this.resolveFile(linkPath);
        Path existing = this.fileSystem.getPath(existingPath, new String[0]);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("createLink({})[id={}], existing={}[{}], link={}[{}], symlink={})", new Object[]{session, id, linkPath, link, existingPath, existing, symLink});
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.linking(session, link, existing, symLink);
        try {
            if (symLink) {
                Files.createSymbolicLink(link, existing, new FileAttribute[0]);
            } else {
                Files.createLink(link, existing);
            }
        }
        catch (IOException | RuntimeException e) {
            listener.linked(session, link, existing, symLink, e);
            throw e;
        }
        listener.linked(session, link, existing, symLink, null);
    }

    @Override
    protected void doTextSeek(int id, String handle, long line) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doTextSeek({})[id={}] SSH_FXP_EXTENDED(text-seek) (handle={}[{}], line={})", new Object[]{this.getServerSession(), id, handle, h, line});
        }
        FileHandle fileHandle = this.validateHandle(handle, h, FileHandle.class);
        throw new UnknownServiceException("doTextSeek(" + fileHandle + ")");
    }

    @Override
    protected void doOpenSSHFsync(int id, String handle) throws IOException {
        Handle h = this.handles.get(handle);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHFsync({})[id={}] {}[{}]", new Object[]{session, id, handle, h});
        }
        FileHandle fileHandle = this.validateHandle(handle, h, FileHandle.class);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.syncFileData(session, this, fileHandle.getFile(), fileHandle.getFileHandle(), fileHandle.getFileChannel());
    }

    @Override
    protected void doCheckFileHash(int id, String targetType, String target, Collection<String> algos, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        String a;
        Path path;
        if ("check-file-handle".equalsIgnoreCase(targetType)) {
            Handle h = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h, FileHandle.class);
            path = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException(path.toString(), path.toString(), "File not opened for read");
            }
        } else {
            path = this.resolveFile(target);
            for (int index = 0; Files.isSymbolicLink(path) && index < 127; ++index) {
                path = Files.readSymbolicLink(path);
            }
            if (Files.isSymbolicLink(path)) {
                throw new FileSystemLoopException(target);
            }
            if (Files.isDirectory(path, IoUtils.getLinkOptions((boolean)false))) {
                throw new NotDirectoryException(path.toString());
            }
        }
        ValidateUtils.checkNotNullAndNotEmpty(algos, (String)"No hash algorithms specified", (Object[])new Object[0]);
        BuiltinDigests factory = null;
        Iterator<String> iterator = algos.iterator();
        while (iterator.hasNext() && ((factory = BuiltinDigests.fromFactoryName((String)(a = iterator.next()))) == null || !factory.isSupported())) {
        }
        ValidateUtils.checkNotNull(factory, (String)"No matching digest factory found for %s", algos);
        this.doCheckFileHash(id, path, (NamedFactory<? extends Digest>)factory, startOffset, length, blockSize, buffer);
    }

    @Override
    protected byte[] doMD5Hash(int id, String targetType, String target, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        Path path;
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMD5Hash({})({})[{}] offset={}, length={}, quick-hash={}", new Object[]{this.getServerSession(), targetType, target, startOffset, length, BufferUtils.toHex((char)':', (byte[])quickCheckHash)});
        }
        if ("md5-hash-handle".equalsIgnoreCase(targetType)) {
            Handle h = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h, FileHandle.class);
            path = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException(path.toString(), path.toString(), "File not opened for read");
            }
        } else {
            path = this.resolveFile(target);
            if (Files.isDirectory(path, IoUtils.getLinkOptions((boolean)true))) {
                throw new NotDirectoryException(path.toString());
            }
        }
        long effectiveLength = length;
        long totalSize = Files.size(path);
        if (startOffset == 0L && length == 0L) {
            effectiveLength = totalSize;
        } else {
            long maxRead = startOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - startOffset;
            }
        }
        return this.doMD5Hash(id, path, startOffset, effectiveLength, quickCheckHash);
    }

    @Override
    protected void doVersionSelect(Buffer buffer, int id, String proposed) throws IOException {
        ServerSession session = this.getServerSession();
        if (this.requestsCount.get() > 0L) {
            this.sendStatus(this.prepareReply(buffer), id, 4, "Version selection not the 1st request for proposal = " + proposed);
            session.close(true);
            return;
        }
        Boolean result = this.validateProposedVersion(buffer, id, proposed);
        if (result == null) {
            session.close(true);
            return;
        }
        if (result.booleanValue()) {
            this.version = Integer.parseInt(proposed);
            this.sendStatus(this.prepareReply(buffer), id, 0, "");
        } else {
            this.sendStatus(this.prepareReply(buffer), id, 4, "Unsupported version " + proposed);
            session.close(true);
        }
    }

    @Override
    protected void doBlock(int id, String handle, long offset, long length, int mask) throws IOException {
        Handle p = this.handles.get(handle);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doBlock({})[id={}] SSH_FXP_BLOCK (handle={}[{}], offset={}, length={}, mask=0x{})", new Object[]{session, id, handle, p, offset, length, Integer.toHexString(mask)});
        }
        FileHandle fileHandle = this.validateHandle(handle, p, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.blocking(session, handle, fileHandle, offset, length, mask);
        try {
            fileHandle.lock(offset, length, mask);
        }
        catch (IOException | RuntimeException e) {
            listener.blocked(session, handle, fileHandle, offset, length, mask, e);
            throw e;
        }
        listener.blocked(session, handle, fileHandle, offset, length, mask, null);
    }

    @Override
    protected void doUnblock(int id, String handle, long offset, long length) throws IOException {
        Handle p = this.handles.get(handle);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doUnblock({})[id={}] SSH_FXP_UNBLOCK (handle={}[{}], offset={}, length={})", new Object[]{session, id, handle, p, offset, length});
        }
        FileHandle fileHandle = this.validateHandle(handle, p, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.unblocking(session, handle, fileHandle, offset, length);
        try {
            fileHandle.unlock(offset, length);
        }
        catch (IOException | RuntimeException e) {
            listener.unblocked(session, handle, fileHandle, offset, length, e);
            throw e;
        }
        listener.unblocked(session, handle, fileHandle, offset, length, null);
    }

    @Override
    protected void doCopyData(int id, String readHandle, long readOffset, long readLength, String writeHandle, long writeOffset) throws IOException {
        Handle wh;
        boolean inPlaceCopy = readHandle.equals(writeHandle);
        Handle rh = this.handles.get(readHandle);
        Handle handle = wh = inPlaceCopy ? rh : this.handles.get(writeHandle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doCopyData({})[id={}] SSH_FXP_EXTENDED[{}] read={}[{}], read-offset={}, read-length={}, write={}[{}], write-offset={})", new Object[]{this.getServerSession(), id, "copy-data", readHandle, rh, readOffset, readLength, writeHandle, wh, writeOffset});
        }
        FileHandle srcHandle = this.validateHandle(readHandle, rh, FileHandle.class);
        Path srcPath = srcHandle.getFile();
        int srcAccess = srcHandle.getAccessMask();
        if ((srcAccess & 1) != 1) {
            throw new AccessDeniedException(srcPath.toString(), srcPath.toString(), "Source file not opened for read");
        }
        ValidateUtils.checkTrue((readLength >= 0L ? 1 : 0) != 0, (String)"Invalid read length: %d", (long)readLength);
        ValidateUtils.checkTrue((readOffset >= 0L ? 1 : 0) != 0, (String)"Invalid read offset: %d", (long)readOffset);
        long totalSize = Files.size(srcHandle.getFile());
        long effectiveLength = readLength;
        if (effectiveLength == 0L) {
            effectiveLength = totalSize - readOffset;
        } else {
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - readOffset;
            }
        }
        ValidateUtils.checkTrue((effectiveLength > 0L ? 1 : 0) != 0, (String)"Non-positive effective copy data length: %d", (long)effectiveLength);
        FileHandle dstHandle = inPlaceCopy ? srcHandle : this.validateHandle(writeHandle, wh, FileHandle.class);
        int dstAccess = dstHandle.getAccessMask();
        if ((dstAccess & 2) != 2) {
            throw new AccessDeniedException(srcHandle.toString(), srcHandle.toString(), "Source handle not opened for write");
        }
        ValidateUtils.checkTrue((writeOffset >= 0L ? 1 : 0) != 0, (String)"Invalid write offset: %d", (long)writeOffset);
        if (inPlaceCopy) {
            long maxWrite;
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                maxRead = totalSize;
            }
            if ((maxWrite = writeOffset + effectiveLength) > readOffset) {
                throw new IllegalArgumentException("Write range end [" + writeOffset + "-" + maxWrite + "] overlaps with read range [" + readOffset + "-" + maxRead + "]");
            }
            if (maxRead > writeOffset) {
                throw new IllegalArgumentException("Read range end [" + readOffset + "-" + maxRead + "] overlaps with write range [" + writeOffset + "-" + maxWrite + "]");
            }
        }
        byte[] copyBuf = new byte[Math.min(8192, (int)effectiveLength)];
        while (effectiveLength > 0L) {
            int remainLength = Math.min(copyBuf.length, (int)effectiveLength);
            int readLen = srcHandle.read(copyBuf, 0, remainLength, readOffset);
            if (readLen < 0) {
                throw new EOFException("Premature EOF while still remaining " + effectiveLength + " bytes");
            }
            dstHandle.write(copyBuf, 0, readLen, writeOffset);
            effectiveLength -= (long)readLen;
            readOffset += (long)readLen;
            writeOffset += (long)readLen;
        }
    }

    @Override
    protected void doReadDir(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        Handle h = this.handles.get(handle);
        ServerSession session = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doReadDir({})[id={}] SSH_FXP_READDIR (handle={}[{}])", new Object[]{session, id, handle, h});
        }
        Buffer reply = null;
        try {
            LinkOption[] options;
            DirectoryHandle dh = this.validateHandle(handle, h, DirectoryHandle.class);
            if (dh.isDone()) {
                this.sendStatus(this.prepareReply(buffer), id, 1, "Directory reading is done");
                return;
            }
            Path file = dh.getFile();
            Boolean status = IoUtils.checkFileExists((Path)file, (LinkOption[])(options = this.getPathResolutionLinkOption(12, "", file)));
            if (status == null) {
                throw new AccessDeniedException(file.toString(), file.toString(), "Cannot determine existence of read-dir");
            }
            if (!status.booleanValue()) {
                throw new NoSuchFileException(file.toString(), file.toString(), "Non-existent directory");
            }
            if (!Files.isDirectory(file, options)) {
                throw new NotDirectoryException(file.toString());
            }
            if (!Files.isReadable(file)) {
                throw new AccessDeniedException(file.toString(), file.toString(), "Not readable");
            }
            if (dh.isSendDot() || dh.isSendDotDot() || dh.hasNext()) {
                reply = this.prepareReply(buffer);
                reply.putByte((byte)104);
                reply.putInt((long)id);
                int lenPos = reply.wpos();
                reply.putInt(0L);
                int maxDataSize = session.getIntProperty(MAX_READDIR_DATA_SIZE_PROP, 16384);
                int count = this.doReadDir(id, handle, dh, reply, maxDataSize, IoUtils.getLinkOptions((boolean)false));
                BufferUtils.updateLengthPlaceholder((Buffer)reply, (int)lenPos, (int)count);
                if (!(dh.isSendDot() || dh.isSendDotDot() || dh.hasNext())) {
                    dh.markDone();
                }
                Boolean indicator = SftpHelper.indicateEndOfNamesList(reply, this.getVersion(), (PropertyResolver)session, dh.isDone());
                if (debugEnabled) {
                    this.log.debug("doReadDir({})({})[{}] - seding {} entries - eol={}", new Object[]{session, handle, h, count, indicator});
                }
            } else {
                dh.markDone();
                this.sendStatus(this.prepareReply(buffer), id, 1, "Empty directory");
                return;
            }
            Objects.requireNonNull(reply, "No reply buffer created");
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(this.prepareReply(buffer), id, e, 12, handle);
            return;
        }
        this.send(reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doOpenDir(int id, String path, Path p, LinkOption ... options) throws IOException {
        String handle;
        Boolean status = IoUtils.checkFileExists((Path)p, (LinkOption[])options);
        if (status == null) {
            throw this.signalOpenFailure(id, path, p, true, new AccessDeniedException(p.toString(), p.toString(), "Cannot determine open-dir existence"));
        }
        if (!status.booleanValue()) {
            throw this.signalOpenFailure(id, path, p, true, new NoSuchFileException(path, path, "Referenced target directory N/A"));
        }
        if (!Files.isDirectory(p, options)) {
            throw this.signalOpenFailure(id, path, p, true, new NotDirectoryException(path));
        }
        if (!Files.isReadable(p)) {
            throw this.signalOpenFailure(id, path, p, true, new AccessDeniedException(p.toString(), p.toString(), "Not readable"));
        }
        try {
            Map<String, Handle> map = this.handles;
            synchronized (map) {
                handle = this.generateFileHandle(p);
                DirectoryHandle dirHandle = new DirectoryHandle(this, p, handle);
                this.handles.put(handle, dirHandle);
            }
        }
        catch (IOException e) {
            throw this.signalOpenFailure(id, path, p, true, e);
        }
        return handle;
    }

    @Override
    protected void doFSetStat(int id, String handle, Map<String, ?> attrs) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doFsetStat({})[id={}] SSH_FXP_FSETSTAT (handle={}[{}], attrs={})", new Object[]{this.getServerSession(), id, handle, h, attrs});
        }
        Handle fileHandle = this.validateHandle(handle, h, Handle.class);
        this.doSetAttributes(fileHandle.getFile(), attrs);
    }

    @Override
    protected Map<String, Object> doFStat(int id, String handle, int flags) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doFStat({})[id={}] SSH_FXP_FSTAT (handle={}[{}], flags=0x{})", new Object[]{this.getServerSession(), id, handle, h, Integer.toHexString(flags)});
        }
        Handle fileHandle = this.validateHandle(handle, h, Handle.class);
        return this.resolveFileAttributes(fileHandle.getFile(), flags, IoUtils.getLinkOptions((boolean)true));
    }

    @Override
    protected void doWrite(int id, String handle, long offset, int length, byte[] data, int doff, int remaining) throws IOException {
        Handle h = this.handles.get(handle);
        ServerSession session = this.getServerSession();
        if (this.log.isTraceEnabled()) {
            this.log.trace("doWrite({})[id={}] SSH_FXP_WRITE (handle={}[{}], offset={}, data=byte[{}])", new Object[]{session, id, handle, h, offset, length});
        }
        FileHandle fh = this.validateHandle(handle, h, FileHandle.class);
        if (length < 0) {
            throw new IllegalStateException("Bad length (" + length + ") for writing to " + fh);
        }
        if (remaining < length) {
            throw new IllegalStateException("Not enough buffer data for writing to " + fh + ": required=" + length + ", available=" + remaining);
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.writing(session, handle, fh, offset, data, doff, length);
        try {
            if (fh.isOpenAppend()) {
                fh.append(data, doff, length);
            } else {
                fh.write(data, doff, length, offset);
            }
        }
        catch (IOException | RuntimeException e) {
            listener.written(session, handle, fh, offset, data, doff, length, e);
            throw e;
        }
        listener.written(session, handle, fh, offset, data, doff, length, null);
    }

    @Override
    protected int doRead(int id, String handle, long offset, int length, byte[] data, int doff) throws IOException {
        int readLen;
        Handle h = this.handles.get(handle);
        ServerSession session = this.getServerSession();
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[id={}] SSH_FXP_READ (handle={}[{}], offset={}, length={})", new Object[]{session, id, handle, h, offset, length});
        }
        ValidateUtils.checkTrue(((long)length > 0L ? 1 : 0) != 0, (String)"Invalid read length: %d", (long)length);
        FileHandle fh = this.validateHandle(handle, h, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.reading(session, handle, fh, offset, data, doff, length);
        try {
            readLen = fh.read(data, doff, length, offset);
        }
        catch (IOException | RuntimeException e) {
            listener.read(session, handle, fh, offset, data, doff, length, -1, e);
            throw e;
        }
        listener.read(session, handle, fh, offset, data, doff, length, readLen, null);
        return readLen;
    }

    @Override
    protected void doClose(int id, String handle) throws IOException {
        Handle h = this.handles.remove(handle);
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doClose({})[id={}] SSH_FXP_CLOSE (handle={}[{}])", new Object[]{session, id, handle, h});
        }
        Handle nodeHandle = this.validateHandle(handle, h, Handle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        try {
            listener.closing(session, handle, nodeHandle);
            nodeHandle.close();
            listener.closed(session, handle, nodeHandle, null);
        }
        catch (IOException | RuntimeException e) {
            listener.closed(session, handle, nodeHandle, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doOpen(int id, String path, int pflags, int access, Map<String, Object> attrs) throws IOException {
        String handle;
        int maxHandleCount;
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({})[id={}] SSH_FXP_OPEN (path={}, access=0x{}, pflags=0x{}, attrs={})", new Object[]{session, id, path, Integer.toHexString(access), Integer.toHexString(pflags), attrs});
        }
        Path file = this.resolveFile(path);
        int curHandleCount = this.handles.size();
        if (curHandleCount > (maxHandleCount = session.getIntProperty(MAX_OPEN_HANDLES_PER_SESSION, Integer.MAX_VALUE))) {
            throw this.signalOpenFailure(id, path, file, false, new SftpException(14, "Too many open handles: current=" + curHandleCount + ", max.=" + maxHandleCount));
        }
        try {
            Map<String, Handle> map = this.handles;
            synchronized (map) {
                handle = this.generateFileHandle(file);
                FileHandle fileHandle = new FileHandle(this, file, handle, pflags, access, attrs);
                this.handles.put(handle, fileHandle);
            }
        }
        catch (IOException e) {
            throw this.signalOpenFailure(id, path, file, false, e);
        }
        return handle;
    }

    protected String generateFileHandle(Path file) throws IOException {
        ServerSession session = this.getServerSession();
        boolean traceEnabled = this.log.isTraceEnabled();
        for (int index = 0; index < this.maxFileHandleRounds; ++index) {
            this.randomizer.fill(this.workBuf, 0, this.fileHandleSize);
            String handle = BufferUtils.toHex((byte[])this.workBuf, (int)0, (int)this.fileHandleSize, (char)'\u0000');
            if (this.handles.containsKey(handle)) {
                if (!traceEnabled) continue;
                this.log.trace("generateFileHandle({})[{}] handle={} in use at round {}", new Object[]{session, file, handle, index});
                continue;
            }
            if (traceEnabled) {
                this.log.trace("generateFileHandle({})[{}] {}", new Object[]{session, file, handle});
            }
            return handle;
        }
        throw new StreamCorruptedException("Failed to generate a unique file handle for " + file);
    }

    @Override
    protected void doInit(Buffer buffer, int id) throws IOException {
        String all;
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doInit({})[id={}] SSH_FXP_INIT (version={})", new Object[]{session, id, id});
        }
        if (GenericUtils.isEmpty((CharSequence)(all = this.checkVersionCompatibility(buffer, id, id, 8)))) {
            return;
        }
        this.version = id;
        while (buffer.available() > 0) {
            String name = buffer.getString();
            byte[] data = buffer.getBytes();
            this.extensions.put(name, data);
        }
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)2);
        buffer.putInt((long)this.version);
        this.appendExtensions(buffer, all);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.initialized(session, this.version);
        this.send(buffer);
    }

    @Override
    protected Buffer prepareReply(Buffer buffer) {
        buffer.clear();
        buffer.putInt(0L);
        return buffer;
    }

    @Override
    protected void send(Buffer buffer) throws IOException {
        BufferUtils.updateLengthPlaceholder((Buffer)buffer, (int)0);
        this.out.writePacket(buffer);
    }

    public void destroy() {
        block13: {
            boolean debugEnabled;
            ServerSession session;
            block12: {
                if (this.closed.getAndSet(true)) {
                    return;
                }
                session = this.getServerSession();
                debugEnabled = this.log.isDebugEnabled();
                if (debugEnabled) {
                    this.log.debug("destroy({}) - mark as closed", (Object)session);
                }
                try {
                    SftpEventListener listener = this.getSftpEventListenerProxy();
                    listener.destroying(session);
                }
                catch (Exception e) {
                    this.log.warn("destroy({}) Failed ({}) to announce destruction event: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
                    if (!debugEnabled) break block12;
                    this.log.debug("destroy(" + session + ") destruction announcement failure details", (Throwable)e);
                }
            }
            if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
                boolean result = this.pendingFuture.cancel(true);
                if (debugEnabled) {
                    this.log.debug("destroy(" + session + ") - cancel pending future=" + result);
                }
            }
            this.pendingFuture = null;
            CloseableExecutorService executors = this.getExecutorService();
            if (executors != null && !executors.isShutdown()) {
                List runners = executors.shutdownNow();
                if (debugEnabled) {
                    this.log.debug("destroy(" + session + ") - shutdown executor service - runners count=" + runners.size());
                }
            }
            this.executorService = null;
            try {
                this.fileSystem.close();
            }
            catch (UnsupportedOperationException e) {
                if (debugEnabled) {
                    this.log.debug("destroy(" + session + ") closing the file system is not supported");
                }
            }
            catch (IOException e) {
                if (!debugEnabled) break block13;
                this.log.debug("destroy(" + session + ") failed (" + e.getClass().getSimpleName() + ") to close file system: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void closeAllHandles() {
        boolean debugEnabled = this.log.isDebugEnabled();
        ServerSession session = this.getServerSession();
        this.handles.forEach((arg_0, arg_1) -> this.lambda$closeAllHandles$0(debugEnabled, (Session)session, arg_0, arg_1));
        this.handles.clear();
    }

    private /* synthetic */ void lambda$closeAllHandles$0(boolean debugEnabled, Session session, String id, Handle handle) {
        try {
            handle.close();
            if (debugEnabled) {
                this.log.debug("closeAllHandles({}) closed pending handle {} [{}]", new Object[]{session, id, handle});
            }
        }
        catch (IOException e) {
            this.log.error("closeAllHandles({}) failed ({}) to close handle={}[{}]: {}", new Object[]{session, e.getClass().getSimpleName(), id, handle, e.getMessage()});
        }
    }
}

