/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.rmi.RemoteException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.entity.bmp.BasicBmpHome;
import org.apache.openejb.test.entity.bmp.BasicBmpObject;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulObject;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;
import org.apache.openejb.test.stateless.BasicStatelessBusinessRemote;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessObject;
import org.apache.openejb.test.stateless.BasicStatelessPojoBean;
import org.junit.Assert;

public class ContextLookupStatelessPojoBean {
    public void lookupEntityBean() throws TestFailureException {
        try {
            try {
                BasicBmpHome home = (BasicBmpHome)this.getSessionContext().lookup("stateless/beanReferences/bmp_entity");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicBmpObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBean() throws TestFailureException {
        try {
            try {
                BasicStatefulHome home = (BasicStatefulHome)this.getSessionContext().lookup("stateless/beanReferences/stateful");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatefulObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBean() throws TestFailureException {
        try {
            try {
                BasicStatelessHome home = (BasicStatelessHome)this.getSessionContext().lookup("stateless/beanReferences/stateless");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatelessObject object = home.createObject();
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatelessBusinessLocal object = (BasicStatelessBusinessLocal)this.getSessionContext().lookup("stateless/beanReferences/stateless-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatelessBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatelessBusinessRemote object = (BasicStatelessBusinessRemote)this.getSessionContext().lookup("stateless/beanReferences/stateless-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessLocal object = (BasicStatefulBusinessLocal)this.getSessionContext().lookup("stateless/beanReferences/stateful-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessLocalBean() throws TestFailureException {
        try {
            try {
                BasicStatelessPojoBean object = (BasicStatelessPojoBean)this.getSessionContext().lookup("stateless/beanReferences/stateful-business-localbean");
                Assert.assertNotNull((String)"The EJB BusinessLocalBean is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStatefulBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessRemote object = (BasicStatefulBusinessRemote)this.getSessionContext().lookup("stateless/beanReferences/stateful-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupStringEntry() throws TestFailureException {
        try {
            try {
                String expected = new String("1");
                String actual = (String)this.getSessionContext().lookup("stateless/references/String");
                Assert.assertNotNull((String)"The String looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupDoubleEntry() throws TestFailureException {
        try {
            try {
                Double expected = new Double(1.0);
                Double actual = (Double)this.getSessionContext().lookup("stateless/references/Double");
                Assert.assertNotNull((String)"The Double looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupLongEntry() throws TestFailureException {
        try {
            try {
                Long expected = new Long(1L);
                Long actual = (Long)this.getSessionContext().lookup("stateless/references/Long");
                Assert.assertNotNull((String)"The Long looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupFloatEntry() throws TestFailureException {
        try {
            try {
                Float expected = new Float(1.0f);
                Float actual = (Float)this.getSessionContext().lookup("stateless/references/Float");
                Assert.assertNotNull((String)"The Float looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupIntegerEntry() throws TestFailureException {
        try {
            try {
                Integer expected = new Integer(1);
                Integer actual = (Integer)this.getSessionContext().lookup("stateless/references/Integer");
                Assert.assertNotNull((String)"The Integer looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupShortEntry() throws TestFailureException {
        try {
            try {
                Short expected = new Short(1);
                Short actual = (Short)this.getSessionContext().lookup("stateless/references/Short");
                Assert.assertNotNull((String)"The Short looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupBooleanEntry() throws TestFailureException {
        try {
            try {
                Boolean expected = Boolean.TRUE;
                Boolean actual = (Boolean)this.getSessionContext().lookup("stateless/references/Boolean");
                Assert.assertNotNull((String)"The Boolean looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupByteEntry() throws TestFailureException {
        try {
            try {
                Byte expected = new Byte(1);
                Byte actual = (Byte)this.getSessionContext().lookup("stateless/references/Byte");
                Assert.assertNotNull((String)"The Byte looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupCharacterEntry() throws TestFailureException {
        try {
            try {
                Character expected = new Character('D');
                Character actual = (Character)this.getSessionContext().lookup("stateless/references/Character");
                Assert.assertNotNull((String)"The Character looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupResource() throws TestFailureException {
        try {
            try {
                Object obj = this.getSessionContext().lookup("datasource");
                Assert.assertNotNull((String)"The DataSource is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of DataSource", (boolean)(obj instanceof DataSource));
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupPersistenceUnit() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManagerFactory emf = (EntityManagerFactory)ctx.lookup("java:comp/env/persistence/TestUnit");
                Assert.assertNotNull((String)"The EntityManagerFactory is null", (Object)emf);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupSessionContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                SessionContext sctx = (SessionContext)ctx.lookup("java:comp/env/sessioncontext");
                Assert.assertNotNull((String)"The SessionContext got from java:comp/env/sessioncontext is null", (Object)sctx);
                EJBContext ejbCtx = (EJBContext)ctx.lookup("java:comp/EJBContext");
                Assert.assertNotNull((String)"The SessionContext got from java:comp/EJBContext is null ", (Object)ejbCtx);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void lookupPersistenceContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManager em = (EntityManager)ctx.lookup("java:comp/env/persistence/TestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public SessionContext getSessionContext() throws EJBException, RemoteException {
        SessionContext ejbContext = null;
        try {
            ejbContext = (SessionContext)new InitialContext().lookup("java:comp/EJBContext");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return ejbContext;
    }

    public void lookupStatelessBusinessLocalBean() throws TestFailureException {
        try {
            try {
                BasicStatelessPojoBean object = (BasicStatelessPojoBean)this.getSessionContext().lookup("stateless/beanReferences/stateless-business-localbean");
                Assert.assertNotNull((String)"The EJB BusinessLocalBean is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }
}

