/*
 * Decompiled with CFR 0.152.
 */
package org.bekwam.maven.plugin.talendroutine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class TalendRoutineMojo
extends AbstractMojo {
    private static final String PROJECT_FILE_NAME = "talend.project";
    private static final String PROPERTY_ID = "_NkZ6AJEEEeC4zfWT--Xipg";
    @Parameter(defaultValue="${project}", property="project", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/TALENDROUTINE", property="outputDir", required=true)
    private File outputDir;
    @Parameter(defaultValue="${project.name}", property="label", required=true)
    private String label;
    @Parameter(defaultValue="Talend routines", property="description", required=true)
    private String description;
    @Parameter(defaultValue="Talend routines", property="purpose", required=true)
    private String purpose;
    @Parameter(defaultValue="1.0", property="version", required=true)
    private String version;
    @Parameter(defaultValue="routines", property="path", required=true)
    private String path;

    public void execute() throws MojoExecutionException {
        File f = this.outputDir;
        if (!f.exists()) {
            f.mkdirs();
        }
        String filename = String.valueOf(this.label) + "_" + this.version + ".properties";
        String xmiId = "_" + RandomStringUtils.randomAlphanumeric((int)22);
        String id = PROPERTY_ID;
        String routineId = "_" + RandomStringUtils.randomAlphanumeric((int)22);
        String stateId = "_" + RandomStringUtils.randomAlphanumeric((int)22);
        String authorId = "_" + RandomStringUtils.randomAlphanumeric((int)22);
        this.getLog().debug((CharSequence)("generating filename=" + filename));
        this.getLog().debug((CharSequence)("using xmiId=" + xmiId));
        File propertiesFile = new File(f, filename);
        File talendProjectFile = new File(f, PROJECT_FILE_NAME);
        FileWriter w = null;
        BufferedWriter bw = null;
        try {
            try {
                w = new FileWriter(propertiesFile);
                bw = new BufferedWriter(w);
                DateTime dt = new DateTime();
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                String date_s = fmt.print((ReadableInstant)dt);
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.newLine();
                bw.write("<xmi:XMI xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:TalendProperties=\"http://www.talend.org/properties\">");
                bw.newLine();
                bw.write("  <TalendProperties:Property xmi:id=\"" + xmiId + "\" id=\"" + id + "\" label=\"" + this.label + "\" purpose=\"" + this.purpose + "\" description=\"" + this.description + "\" creationDate=\"" + date_s + "\" modificationDate=\"" + date_s + "\" version=\"" + this.version + "\" statusCode=\"PROD\" item=\"" + routineId + "\"> ");
                bw.newLine();
                bw.write("    <author href=\"../../../talend.project#" + authorId + "\"/>");
                bw.newLine();
                bw.write("  </TalendProperties:Property>");
                bw.newLine();
                bw.write("  <TalendProperties:ItemState xmi:id=\"" + stateId + "\" path=\"" + this.path + "\"/>");
                bw.newLine();
                bw.write("  <TalendProperties:RoutineItem xmi:id=\"" + routineId + "\" property=\"" + xmiId + "\" state=\"" + stateId + "\"> ");
                bw.newLine();
                bw.write("    <content href=\"" + this.label + "_" + this.version + ".item#/0\"/>");
                bw.newLine();
                Set artifacts = this.project.getDependencyArtifacts();
                for (Artifact a : artifacts) {
                    if (StringUtils.equals((String)a.getScope(), (String)"test") || !StringUtils.equals((String)a.getType(), (String)"jar")) continue;
                    String jarName = String.valueOf(a.getArtifactId()) + "-" + a.getVersion() + ".jar";
                    String message = "Required for using this component.";
                    this.getLog().debug((CharSequence)("jarName=" + jarName + ", message=" + message));
                    String importId = "_" + RandomStringUtils.randomAlphanumeric((int)22);
                    bw.write("    <imports xmi:id=\"" + importId + "\" mESSAGE=\"" + message + "\" mODULE=\"" + jarName + "\" nAME=\"" + a.getArtifactId() + "\" rEQUIRED=\"true\" />");
                    bw.newLine();
                }
                bw.write("    </TalendProperties:RoutineItem>");
                bw.newLine();
                bw.write("</xmi:XMI>");
                bw.newLine();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + propertiesFile, (Exception)e);
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("error closing buffered writer for file=" + filename));
                }
            }
        }
        try {
            try {
                w = new FileWriter(talendProjectFile);
                bw = new BufferedWriter(w);
                String projectId = "_" + RandomStringUtils.randomAlphanumeric((int)22);
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.newLine();
                bw.write("<xmi:XMI xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:TalendProperties=\"http://www.talend.org/properties\">");
                bw.newLine();
                bw.write("  <TalendProperties:Project xmi:id=\"" + projectId + "\" label=\"TALENDPROJECT\" description=\"Project for testing new components\" language=\"java\" technicalLabel=\"TALENDPROJECT\" local=\"true\" productVersion=\"Talend Open Studio-4.2.2.r63143\" itemsRelationVersion=\"1.1\">");
                bw.newLine();
                bw.write("  </TalendProperties:Project>");
                bw.newLine();
                bw.write("  <TalendProperties:User xmi:id=\"" + authorId + "\" login=\"exportuser@talend.com\"/>");
                bw.newLine();
                bw.write("</xmi:XMI>");
                bw.newLine();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + talendProjectFile, (Exception)e);
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("error closing buffered writer for file=" + filename));
                }
            }
        }
    }
}

