/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.InvalidPageTokenException;
import org.bonitasoft.engine.exception.InvalidPageZipContentException;
import org.bonitasoft.engine.exception.InvalidPageZipInconsistentException;
import org.bonitasoft.engine.exception.InvalidPageZipMissingAPropertyException;
import org.bonitasoft.engine.exception.InvalidPageZipMissingIndexException;
import org.bonitasoft.engine.exception.InvalidPageZipMissingPropertiesException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UnauthorizedAccessException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.exception.UpdatingWithInvalidPageTokenException;
import org.bonitasoft.engine.exception.UpdatingWithInvalidPageZipContentException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.page.PageCreator;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.page.PageURL;
import org.bonitasoft.engine.page.PageUpdater;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;

public interface PageAPI {
    public Page getPage(long var1) throws PageNotFoundException;

    public Page getPageByName(String var1) throws PageNotFoundException;

    public Page getPageByNameAndProcessDefinitionId(String var1, long var2) throws PageNotFoundException;

    public byte[] getPageContent(long var1) throws PageNotFoundException;

    public SearchResult<Page> searchPages(SearchOptions var1) throws SearchException;

    public Page createPage(PageCreator var1, byte[] var2) throws AlreadyExistsException, CreationException, InvalidPageTokenException, InvalidPageZipContentException;

    public Page updatePage(long var1, PageUpdater var3) throws UpdateException, AlreadyExistsException, UpdatingWithInvalidPageTokenException, UpdatingWithInvalidPageZipContentException;

    public void updatePageContent(long var1, byte[] var3) throws UpdateException, UpdatingWithInvalidPageTokenException, UpdatingWithInvalidPageZipContentException;

    public void deletePage(long var1) throws DeletionException;

    public void deletePages(List<Long> var1) throws DeletionException;

    public Page createPage(String var1, byte[] var2) throws AlreadyExistsException, CreationException, InvalidPageTokenException, InvalidPageZipContentException;

    public Properties getPageProperties(byte[] var1, boolean var2) throws InvalidPageTokenException, AlreadyExistsException, InvalidPageZipMissingPropertiesException, InvalidPageZipMissingIndexException, InvalidPageZipInconsistentException, InvalidPageZipMissingAPropertyException;

    public PageURL resolvePageOrURL(String var1, Map<String, Serializable> var2, boolean var3) throws NotFoundException, UnauthorizedAccessException, ExecutionException;
}

