/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bonitasoft.engine.bdm.CountQueryGenerator;
import org.bonitasoft.engine.bdm.FindQueryGenerator;
import org.bonitasoft.engine.bdm.QueryGenerator;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.model.field.SimpleField;

public class BDMQueryUtil {
    public static final String MAX_RESULTS_PARAM_NAME = "maxResults";
    public static final String START_INDEX_PARAM_NAME = "startIndex";

    public static List<Query> createProvidedQueriesForBusinessObject(BusinessObject businessObject) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (QueryGenerator queryGenerator : BDMQueryUtil.getQueryGenerators()) {
            BDMQueryUtil.createProvidedQueriesForBusinessObject(businessObject, queries, queryGenerator);
        }
        return queries;
    }

    protected static void createProvidedQueriesForBusinessObject(BusinessObject businessObject, List<Query> queries, QueryGenerator queryGenerator) {
        HashSet<String> queryNames = new HashSet<String>();
        if (!BDMQueryUtil.containsQueryWithName(businessObject, queryGenerator.getQueryName("persistenceId"))) {
            BDMQueryUtil.addQueryAndNameIfNotNull(queries, queryNames, queryGenerator.createQueryForPersistenceId(businessObject));
        }
        for (UniqueConstraint uniqueConstraint : businessObject.getUniqueConstraints()) {
            BDMQueryUtil.addQueryAndNameIfNotNull(queries, queryNames, queryGenerator.createQueryForUniqueConstraint(businessObject, uniqueConstraint));
        }
        for (Field field : businessObject.getFields()) {
            String potentialConflictingQueryName;
            if (!(field instanceof SimpleField) || field.isCollection() != null && field.isCollection().booleanValue() || queryNames.contains(potentialConflictingQueryName = queryGenerator.createQueryNameForField(field))) continue;
            BDMQueryUtil.addQueryIfNotNull(queries, queryGenerator.createQueryForField(businessObject, field));
        }
        queries.add(queryGenerator.createSelectAllQueryForBusinessObject(businessObject));
    }

    private static void addQueryAndNameIfNotNull(List<Query> queries, Set<String> queryNames, Query query) {
        if (query != null) {
            BDMQueryUtil.addQueryIfNotNull(queries, query);
            queryNames.add(query.getName());
        }
    }

    private static void addQueryIfNotNull(List<Query> queries, Query query) {
        if (query != null) {
            queries.add(query);
        }
    }

    protected static List<QueryGenerator> getQueryGenerators() {
        ArrayList<QueryGenerator> queryGenerators = new ArrayList<QueryGenerator>();
        queryGenerators.add(new FindQueryGenerator());
        queryGenerators.add(new CountQueryGenerator());
        return queryGenerators;
    }

    public static Set<String> getAllProvidedQueriesNameForBusinessObject(BusinessObject businessObject) {
        HashSet<String> queryNames = new HashSet<String>();
        for (QueryGenerator queryGenerator : BDMQueryUtil.getQueryGenerators()) {
            if (!BDMQueryUtil.containsQueryWithName(businessObject, queryGenerator.getQueryName("persistenceId"))) {
                SimpleField persistenceIdField = new SimpleField();
                persistenceIdField.setName("persistenceId");
                persistenceIdField.setType(FieldType.LONG);
                queryNames.add(queryGenerator.createQueryNameForField(persistenceIdField));
            }
            for (UniqueConstraint uc : businessObject.getUniqueConstraints()) {
                queryNames.add(queryGenerator.createQueryNameForUniqueConstraint(uc));
            }
            for (Field f : businessObject.getFields()) {
                if (!(f instanceof SimpleField) || f.isCollection() != null && f.isCollection().booleanValue()) continue;
                queryNames.add(queryGenerator.createQueryNameForField(f));
            }
            queryNames.add(queryGenerator.getSelectAllQueryName());
        }
        return queryNames;
    }

    private static boolean containsQueryWithName(BusinessObject businessObject, String queryName) {
        for (Query q : businessObject.getQueries()) {
            if (!Objects.equals(queryName, q.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getCountQueryName(String selectQueryName) {
        return "countFor" + selectQueryName.substring(0, 1).toUpperCase() + selectQueryName.substring(1);
    }

    public static List<Query> createProvidedQueriesForLazyField(BusinessObjectModel bom, BusinessObject bo) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (QueryGenerator queryGenerator : BDMQueryUtil.getQueryGenerators()) {
            for (BusinessObject businessObject : bom.getBusinessObjects()) {
                for (Field f : businessObject.getFields()) {
                    Query query;
                    if (!(f instanceof RelationField) || !((RelationField)f).isLazy() || !((RelationField)f).getReference().equals(bo) || (query = queryGenerator.createQueryForLazyField(businessObject, (RelationField)f)) == null) continue;
                    queries.add(query);
                }
            }
        }
        return queries;
    }

    public static List<Query> createCountProvidedQueriesForBusinessObject(BusinessObject businessObject) {
        ArrayList<Query> queries = new ArrayList<Query>();
        CountQueryGenerator queryGenerator = new CountQueryGenerator();
        BDMQueryUtil.createProvidedQueriesForBusinessObject(businessObject, queries, queryGenerator);
        return queries;
    }
}

