/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.io.IOUtils;
import org.xml.sax.SAXException;

public class BusinessObjectModelConverter {
    private static final String BOM_XSD = "/bom.xsd";
    private static final String BOM_XML = "bom.xml";
    private final URL xsdUrl = BusinessObjectModel.class.getResource("/bom.xsd");

    public byte[] zip(BusinessObjectModel bom) throws IOException, JAXBException, SAXException {
        return IOUtils.zip(BOM_XML, this.marshall(bom));
    }

    public byte[] marshall(BusinessObjectModel bom) throws JAXBException, IOException, SAXException {
        String productVersion;
        String modelVersion = bom.getModelVersion();
        if (modelVersion == null || modelVersion.isEmpty()) {
            bom.setModelVersion("1.0");
        }
        if ((productVersion = bom.getProductVersion()) == null || productVersion.isEmpty()) {
            bom.setProductVersion(BusinessObjectModel.CURRENT_PRODUCT_VERSION);
        }
        return IOUtils.marshallObjectToXML(bom, this.xsdUrl);
    }

    public BusinessObjectModel unzip(byte[] zippedBOM) throws IOException, JAXBException, SAXException {
        Map<String, byte[]> files = IOUtils.unzip(zippedBOM);
        byte[] bomXML = files.get(BOM_XML);
        if (bomXML == null) {
            throw new IOException("the file bom.xml is missing in the zip");
        }
        return this.unmarshall(bomXML);
    }

    public BusinessObjectModel unmarshall(byte[] bomXML) throws JAXBException, IOException, SAXException {
        return IOUtils.unmarshallXMLtoObject(bomXML, BusinessObjectModel.class, this.xsdUrl);
    }
}

