/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.QueryParameter;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.BusinessObjectModelValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.BusinessObjectValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.FieldValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.IndexValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.QueryParameterValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.QueryValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.SimpleFieldValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.UniqueConstraintValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.composition.CyclicCompositionValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.composition.UniquenessCompositionValidationRule;

public class BusinessObjectModelValidator {
    private final List<ValidationRule<?>> rules = new ArrayList();

    public BusinessObjectModelValidator() {
        this.rules.add(new BusinessObjectModelValidationRule());
        this.rules.add(new BusinessObjectValidationRule());
        this.rules.add(new FieldValidationRule());
        this.rules.add(new SimpleFieldValidationRule());
        this.rules.add(new UniqueConstraintValidationRule());
        this.rules.add(new IndexValidationRule());
        this.rules.add(new QueryValidationRule());
        this.rules.add(new QueryParameterValidationRule());
        this.rules.add(new UniquenessCompositionValidationRule());
        this.rules.add(new CyclicCompositionValidationRule());
    }

    public ValidationStatus validate(BusinessObjectModel bom) {
        Set<Object> objectsToValidate = this.buildModelTree(bom);
        ValidationStatus status = new ValidationStatus();
        for (Object modelElement : objectsToValidate) {
            for (ValidationRule<?> rule : this.rules) {
                if (!rule.appliesTo(modelElement)) continue;
                status.addValidationStatus(rule.checkRule(modelElement));
            }
        }
        return status;
    }

    private Set<Object> buildModelTree(BusinessObjectModel bom) {
        HashSet<Object> objectsToValidate = new HashSet<Object>();
        objectsToValidate.add(bom);
        for (BusinessObject bo : bom.getBusinessObjects()) {
            objectsToValidate.add(bo);
            for (Field f : bo.getFields()) {
                objectsToValidate.add(f);
            }
            List<UniqueConstraint> uniqueConstraints = bo.getUniqueConstraints();
            for (UniqueConstraint uc : uniqueConstraints) {
                objectsToValidate.add(uc);
            }
            List<Query> queries = bo.getQueries();
            for (Query q : queries) {
                objectsToValidate.add(q);
                for (QueryParameter p : q.getQueryParameters()) {
                    objectsToValidate.add(p);
                }
            }
            for (Index index : bo.getIndexes()) {
                objectsToValidate.add(index);
            }
        }
        return objectsToValidate;
    }

    public List<ValidationRule<?>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }
}

