/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bonitasoft.engine.bdm.model.NamedElement;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;

public class UniqueNameValidator {
    public ValidationStatus validate(Collection<? extends NamedElement> namedElements, String namedElementTypePluralForm) {
        ValidationStatus status = new ValidationStatus();
        Set<String> duplicateNames = this.findDuplicateNames(namedElements);
        for (String name : duplicateNames) {
            status.addError("There are at least two " + namedElementTypePluralForm + " with the same name : " + name);
        }
        return status;
    }

    private Set<String> findDuplicateNames(Collection<? extends NamedElement> list) {
        LinkedHashSet<String> duplicates = new LinkedHashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (NamedElement namedElement : list) {
            if (uniqueNames.add(namedElement.getName())) continue;
            duplicates.add(namedElement.getName());
        }
        return duplicates;
    }
}

