/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.HashSet;
import java.util.List;
import org.bonitasoft.engine.bdm.BDMQueryUtil;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class BusinessObjectModelValidationRule
extends ValidationRule<BusinessObjectModel> {
    public BusinessObjectModelValidationRule() {
        super(BusinessObjectModel.class);
    }

    @Override
    public ValidationStatus validate(BusinessObjectModel bom) {
        ValidationStatus status = new ValidationStatus();
        if (bom.getBusinessObjects().isEmpty()) {
            status.addError("Business object model must have at least one business object declared");
        }
        this.validateQueries(bom, status);
        return status;
    }

    private void validateQueries(BusinessObjectModel bom, ValidationStatus status) {
        for (BusinessObject bo : bom.getBusinessObjects()) {
            List<Query> lazyQueries = BDMQueryUtil.createProvidedQueriesForLazyField(bom, bo);
            HashSet<String> lazyQueryNames = new HashSet<String>();
            for (Query query : lazyQueries) {
                lazyQueryNames.add(query.getName());
            }
            for (Query q : bo.getQueries()) {
                if (!lazyQueryNames.contains(q.getName())) continue;
                status.addError("The query named \"" + q.getName() + "\" already exists for " + bo.getQualifiedName());
            }
        }
    }
}

