/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.bdm.BDMQueryUtil;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class BusinessObjectValidationRule
extends ValidationRule<BusinessObject> {
    private static final String[] RESERVED_PACKAGE_PREFIX = new String[]{"com.bonitasoft.", "org.bonitasoft."};
    private static final int MAX_TABLENAME_LENGTH = 30;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(30);

    public BusinessObjectValidationRule() {
        super(BusinessObject.class);
    }

    @Override
    public ValidationStatus validate(BusinessObject bo) {
        ValidationStatus status = new ValidationStatus();
        String qualifiedName = bo.getQualifiedName();
        if (qualifiedName == null) {
            status.addError("A Business Object must have a qualified name");
            return status;
        }
        for (String reservedPrefix : RESERVED_PACKAGE_PREFIX) {
            if (!qualifiedName.startsWith(reservedPrefix)) continue;
            status.addError("Package " + reservedPrefix + " is reserved. Please choose another package name");
        }
        String simpleName = bo.getSimpleName();
        if (!SourceVersion.isName(qualifiedName) || !this.sqlNameValidator.isValid(simpleName)) {
            status.addError(qualifiedName + " is not a valid Java qualified name");
            return status;
        }
        if (simpleName.contains("_")) {
            status.addError("_ is a forbidden character in business object's name");
        }
        if (bo.getFields().isEmpty()) {
            status.addError(qualifiedName + " must have at least one field declared");
        }
        this.validateConstraints(bo, status);
        this.validateQueries(bo, status);
        return status;
    }

    private void validateQueries(BusinessObject bo, ValidationStatus status) {
        Set<String> queryNames = BDMQueryUtil.getAllProvidedQueriesNameForBusinessObject(bo);
        for (Query q : bo.getQueries()) {
            if (queryNames.contains(q.getName())) {
                status.addError("The query named \"" + q.getName() + "\" already exists for " + bo.getQualifiedName());
                continue;
            }
            queryNames.add(q.getName());
        }
    }

    private void validateConstraints(BusinessObject bo, ValidationStatus status) {
        HashSet<String> constraintNames = new HashSet<String>();
        for (UniqueConstraint uc : bo.getUniqueConstraints()) {
            if (constraintNames.contains(uc.getName())) {
                status.addError("The constraint named \"" + uc.getName() + "\" already exists for " + bo.getQualifiedName());
            } else {
                constraintNames.add(uc.getName());
            }
            for (String fName : uc.getFieldNames()) {
                Field field = this.getField(bo, fName);
                if (field != null) continue;
                status.addError("The field named " + fName + " does not exist in " + bo.getQualifiedName());
            }
        }
    }

    private Field getField(BusinessObject bo, String name) {
        Field found = null;
        List<Field> fields = bo.getFields();
        for (int index = 0; found == null && index < fields.size(); ++index) {
            Field field = bo.getFields().get(index);
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        return found;
    }
}

