/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class IndexValidationRule
extends ValidationRule<Index> {
    private static final int MAX_CONSTRAINTNAME_LENGTH = 25;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(25);

    public IndexValidationRule() {
        super(Index.class);
    }

    @Override
    protected ValidationStatus validate(Index index) {
        ValidationStatus status = new ValidationStatus();
        String name = index.getName();
        if (name == null || name.isEmpty()) {
            status.addError("An index must have name");
            return status;
        }
        boolean isValid = this.sqlNameValidator.isValid(name);
        if (!isValid) {
            status.addError(name + " is not a valid SQL identifier");
        }
        if (index.getFieldNames().isEmpty()) {
            status.addError(name + " index must have at least one field declared");
        }
        return status;
    }
}

