/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.bdm.model.QueryParameter;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class QueryParameterValidationRule
extends ValidationRule<QueryParameter> {
    public static final List<String> FORBIDDEN_PARAMETER_NAMES = Arrays.asList("startIndex", "maxResults");

    public QueryParameterValidationRule() {
        super(QueryParameter.class);
    }

    @Override
    public ValidationStatus validate(QueryParameter parameter) {
        ValidationStatus status = new ValidationStatus();
        String name = parameter.getName();
        if (name == null || name.isEmpty()) {
            status.addError("A parameter must have name");
            return status;
        }
        if (!SourceVersion.isIdentifier(name)) {
            status.addError(name + " is not a valid Java identifier.");
        }
        if (FORBIDDEN_PARAMETER_NAMES.contains(name)) {
            status.addError(name + " is a reserved parameter name. Use a name different from:" + FORBIDDEN_PARAMETER_NAMES);
        }
        if (parameter.getClassName() == null || parameter.getClassName().isEmpty()) {
            status.addError(name + " query parameter must have a classname");
        }
        return status;
    }
}

