/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class QueryValidationRule
extends ValidationRule<Query> {
    private static final int MAX_QUERY_NAME_LENGTH = 150;

    public QueryValidationRule() {
        super(Query.class);
    }

    @Override
    public ValidationStatus validate(Query query) {
        ValidationStatus status = new ValidationStatus();
        String name = query.getName();
        if (name == null || name.isEmpty()) {
            status.addError("A query must have name");
            return status;
        }
        if (!SourceVersion.isIdentifier(name)) {
            status.addError(name + " is not a valid Java identifier.");
        }
        if (name.length() > 150) {
            status.addError(name + " length must be lower than 150 characters.");
        }
        if (query.getContent() == null || query.getContent().isEmpty()) {
            status.addError(name + " query must have a content defined");
        }
        if (query.getReturnType() == null || query.getReturnType().isEmpty()) {
            status.addError(name + " query must have a return type defined");
        }
        return status;
    }
}

