/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class UniqueConstraintValidationRule
extends ValidationRule<UniqueConstraint> {
    private static final int MAX_CONSTRAINTNAME_LENGTH = 25;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(25);

    public UniqueConstraintValidationRule() {
        super(UniqueConstraint.class);
    }

    @Override
    public ValidationStatus validate(UniqueConstraint uc) {
        ValidationStatus status = new ValidationStatus();
        String name = uc.getName();
        if (name == null || name.isEmpty()) {
            status.addError("A unique constraint must have name");
            return status;
        }
        boolean isValid = this.sqlNameValidator.isValid(name);
        if (!isValid) {
            status.addError(name + " is not a valid SQL identifier");
        }
        if (uc.getFieldNames().isEmpty()) {
            status.addError(name + " unique constraint must have at least one field declared");
        }
        return status;
    }
}

