/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import org.bonitasoft.engine.bdm.validator.ValidationStatus;

public abstract class ValidationRule<T> {
    private Class<T> classToApply;

    public ValidationRule(Class<T> classToApply) {
        this.classToApply = classToApply;
    }

    public boolean appliesTo(Object modelElement) {
        return modelElement != null && this.classToApply.isAssignableFrom(modelElement.getClass());
    }

    protected abstract ValidationStatus validate(T var1);

    public ValidationStatus checkRule(Object modelElement) {
        if (!this.appliesTo(modelElement)) {
            throw new IllegalArgumentException(this.getClass().getName() + " doesn't handle validation for " + modelElement.getClass().getName());
        }
        return this.validate(modelElement);
    }
}

