/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.io.IOUtil;

public abstract class GenericFileContribution
implements BusinessArchiveContribution {
    public abstract String getFileName();

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File file = new File(barFolder, this.getFileName());
        if (!file.exists()) {
            return false;
        }
        byte[] content = IOUtil.getContent(file);
        businessArchive.addResource(this.getFileName(), content);
        return true;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        Map<String, byte[]> resources = businessArchive.getResources(this.getFileName());
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            byte[] value = entry.getValue();
            if (value == null) continue;
            File file = new File(barFolder, entry.getKey());
            IOUtil.write(file, entry.getValue());
        }
    }
}

