/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.engine.bpm.ObjectSeeker;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.businessdata.impl.BusinessDataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.impl.DataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.TextDataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.XMLDataDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.LoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.impl.internal.BoundaryEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowNodeDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MultiInstanceLoopCharacteristicsImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.StandardLoopCharacteristicsImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.impl.OperationImpl;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class ActivityDefinitionImpl
extends FlowNodeDefinitionImpl
implements ActivityDefinition {
    private static final long serialVersionUID = 5575175860474559979L;
    @XmlElementWrapper(name="dataDefinitions")
    @XmlElements(value={@XmlElement(type=DataDefinitionImpl.class, name="dataDefinition"), @XmlElement(type=TextDataDefinitionImpl.class, name="textDataDefinition"), @XmlElement(type=XMLDataDefinitionImpl.class, name="xmlDataDefinition")})
    private final List<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
    @XmlElementWrapper(name="BusinessDataDefinitions")
    @XmlElement(type=BusinessDataDefinitionImpl.class, name="BusinessDataDefinition")
    private final List<BusinessDataDefinition> businessDataDefinitions;
    @XmlElementWrapper(name="operations")
    @XmlElement(type=OperationImpl.class, name="operation")
    private final List<Operation> operations = new ArrayList<Operation>();
    @XmlElements(value={@XmlElement(type=StandardLoopCharacteristicsImpl.class, name="standardLoopCharacteristics"), @XmlElement(type=MultiInstanceLoopCharacteristicsImpl.class, name="multiInstanceLoopCharacteristics")})
    private LoopCharacteristics loopCharacteristics;
    @XmlElementWrapper(name="boundaryEvents")
    @XmlElement(type=BoundaryEventDefinitionImpl.class, name="boundaryEvent")
    private final List<BoundaryEventDefinition> boundaryEventDefinitions = new ArrayList<BoundaryEventDefinition>(1);

    public ActivityDefinitionImpl(long id, String name) {
        super(id, name);
        this.businessDataDefinitions = new ArrayList<BusinessDataDefinition>(3);
    }

    public ActivityDefinitionImpl(String name) {
        super(name);
        this.businessDataDefinitions = new ArrayList<BusinessDataDefinition>(3);
    }

    public ActivityDefinitionImpl() {
        this.businessDataDefinitions = new ArrayList<BusinessDataDefinition>(3);
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return this.dataDefinitions;
    }

    public void addDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinitions.add(dataDefinition);
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    @Override
    public List<BoundaryEventDefinition> getBoundaryEventDefinitions() {
        return Collections.unmodifiableList(this.boundaryEventDefinitions);
    }

    public void addBoundaryEventDefinition(BoundaryEventDefinition boundaryEventDefinition) {
        this.boundaryEventDefinitions.add(boundaryEventDefinition);
    }

    @Override
    public LoopCharacteristics getLoopCharacteristics() {
        return this.loopCharacteristics;
    }

    public void setLoopCharacteristics(LoopCharacteristics loopCharacteristics) {
        this.loopCharacteristics = loopCharacteristics;
    }

    @Override
    public List<BusinessDataDefinition> getBusinessDataDefinitions() {
        return this.businessDataDefinitions;
    }

    public void addBusinessDataDefinition(BusinessDataDefinition businessDataDefinition) {
        this.businessDataDefinitions.add(businessDataDefinition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActivityDefinitionImpl that = (ActivityDefinitionImpl)o;
        return Objects.equals(this.dataDefinitions, that.dataDefinitions) && Objects.equals(this.businessDataDefinitions, that.businessDataDefinitions) && Objects.equals(this.operations, that.operations) && Objects.equals(this.loopCharacteristics, that.loopCharacteristics) && Objects.equals(this.boundaryEventDefinitions, that.boundaryEventDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataDefinitions, this.businessDataDefinitions, this.operations, this.loopCharacteristics, this.boundaryEventDefinitions);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("dataDefinitions", this.dataDefinitions).append("businessDataDefinitions", this.businessDataDefinitions).append("operations", this.operations).append("loopCharacteristics", (Object)this.loopCharacteristics).append("boundaryEventDefinitions", this.boundaryEventDefinitions).toString();
    }

    @Override
    public BusinessDataDefinition getBusinessDataDefinition(String name) {
        return ObjectSeeker.getNamedElement(this.businessDataDefinitions, name);
    }

    @Override
    public DataDefinition getDataDefinition(String name) {
        return ObjectSeeker.getNamedElement(this.dataDefinitions, name);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        super.accept(visitor, modelId);
        visitor.find(this, modelId);
    }
}

