/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.impl.DataDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MessageEventTriggerDefinitionImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.impl.ExpressionImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrowMessageEventTriggerDefinitionImpl
extends MessageEventTriggerDefinitionImpl
implements ThrowMessageEventTriggerDefinition {
    private static final long serialVersionUID = -1678256136944568540L;
    @XmlElement(type=ExpressionImpl.class)
    private Expression targetProcess;
    @XmlElement(type=ExpressionImpl.class)
    private Expression targetFlowNode;
    @XmlElement(type=DataDefinitionImpl.class, name="dataDefinition")
    private final List<DataDefinition> dataDefinitions;

    public ThrowMessageEventTriggerDefinitionImpl() {
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String messageName) {
        super(messageName);
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String name, Expression targetProcess, Expression targetFlowNode) {
        super(name);
        this.targetProcess = targetProcess;
        this.targetFlowNode = targetFlowNode;
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String name, Expression targetProcess) {
        super(name);
        this.targetProcess = targetProcess;
        this.targetFlowNode = null;
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String name, Expression targetProcess, Expression targetFlowNode, List<DataDefinition> dataDefinitions, List<CorrelationDefinition> correlations) {
        super(name, correlations);
        this.targetProcess = targetProcess;
        this.targetFlowNode = targetFlowNode;
        this.dataDefinitions = dataDefinitions;
    }

    public ThrowMessageEventTriggerDefinitionImpl(ThrowMessageEventTriggerDefinition trigger) {
        super(trigger);
        this.targetFlowNode = trigger.getTargetFlowNode();
        this.targetProcess = trigger.getTargetProcess();
        this.dataDefinitions = trigger.getDataDefinitions();
    }

    @Override
    public Expression getTargetProcess() {
        return this.targetProcess;
    }

    @Override
    public Expression getTargetFlowNode() {
        return this.targetFlowNode;
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return Collections.unmodifiableList(this.dataDefinitions);
    }

    public void setTargetProcess(Expression targetProcess) {
        this.targetProcess = targetProcess;
    }

    public void setTargetFlowNode(Expression targetFlowNode) {
        this.targetFlowNode = targetFlowNode;
    }

    public void addDataDefinition(DataDefinition datadefiniton) {
        this.dataDefinitions.add(datadefiniton);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrowMessageEventTriggerDefinitionImpl that = (ThrowMessageEventTriggerDefinitionImpl)o;
        return Objects.equals(this.targetProcess, that.targetProcess) && Objects.equals(this.targetFlowNode, that.targetFlowNode) && Objects.equals(this.dataDefinitions, that.dataDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetProcess, this.targetFlowNode, this.dataDefinitions);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        super.accept(visitor, modelId);
        visitor.find(this, modelId);
    }
}

