/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.userfilter.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MapAdapterExpression;
import org.bonitasoft.engine.bpm.internal.NamedDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.bpm.userfilter.UserFilterDefinition;
import org.bonitasoft.engine.expression.Expression;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserFilterDefinitionImpl
extends NamedDefinitionElementImpl
implements UserFilterDefinition {
    private static final long serialVersionUID = -6045216424839658552L;
    @XmlAttribute(name="userFilterId")
    private final String filterId;
    @XmlAttribute
    private final String version;
    @XmlJavaTypeAdapter(value=MapAdapterExpression.class)
    @XmlElement(name="inputs")
    private final Map<String, Expression> inputs = new HashMap<String, Expression>();

    public UserFilterDefinitionImpl(String name, String filterId, String version) {
        super(name);
        this.filterId = filterId;
        this.version = version;
    }

    public UserFilterDefinitionImpl() {
        this.filterId = "default Id";
        this.version = "default version";
    }

    @Override
    public String getUserFilterId() {
        return this.filterId;
    }

    @Override
    public Map<String, Expression> getInputs() {
        return this.inputs;
    }

    public void addInput(String name, Expression expression) {
        this.inputs.put(name, expression);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserFilterDefinitionImpl that = (UserFilterDefinitionImpl)o;
        return Objects.equals(this.filterId, that.filterId) && Objects.equals(this.version, that.version) && Objects.equals(this.inputs, that.inputs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filterId, this.version, this.inputs);
    }

    @Override
    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append("UserFilterDefinitionImpl [filterId=");
        builder.append(this.filterId);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", inputs=");
        builder.append(this.inputs != null ? this.toString(this.inputs.entrySet(), 5) : null);
        builder.append("]");
        return builder.toString();
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }
}

