/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.exception;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.bonitasoft.engine.exception.BonitaContextException;
import org.bonitasoft.engine.exception.ExceptionContext;

public class BonitaException
extends Exception
implements BonitaContextException {
    private static final long serialVersionUID = -5413586694735909486L;
    private final Map<ExceptionContext, Serializable> context = new TreeMap<ExceptionContext, Serializable>();
    private String userName = "";

    public BonitaException(String message, Throwable cause) {
        super(message, cause);
    }

    public BonitaException(String message) {
        super(message);
    }

    public BonitaException(Throwable cause) {
        super(cause);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<ExceptionContext, Serializable> getContext() {
        return this.context;
    }

    public void setProcessDefinitionIdOnContext(Long id) {
        this.context.put(ExceptionContext.PROCESS_DEFINITION_ID, id);
    }

    public void setProcessDefinitionNameOnContext(String name) {
        this.context.put(ExceptionContext.PROCESS_NAME, (Serializable)((Object)name));
    }

    public void setProcessDefinitionVersionOnContext(String version) {
        this.context.put(ExceptionContext.PROCESS_VERSION, (Serializable)((Object)version));
    }

    public void setProcessInstanceIdOnContext(Long id) {
        this.context.put(ExceptionContext.PROCESS_INSTANCE_ID, id);
    }

    public void setRootProcessInstanceIdOnContext(Long id) {
        this.context.put(ExceptionContext.ROOT_PROCESS_INSTANCE_ID, id);
    }

    public void setConnectorDefinitionIdOnContext(String id) {
        this.context.put(ExceptionContext.CONNECTOR_DEFINITION_ID, (Serializable)((Object)id));
    }

    public void setConnectorDefinitionImplementationClassNameOnContext(String name) {
        this.context.put(ExceptionContext.CONNECTOR_DEFINITION_IMPLEMENTATION_CLASS_NAME, (Serializable)((Object)name));
    }

    public void setConnectorDefinitionVersionOnContext(String version) {
        this.context.put(ExceptionContext.CONNECTOR_DEFINITION_VERSION, (Serializable)((Object)version));
    }

    public void setConnectorActivationEventOnContext(String activationEvent) {
        this.context.put(ExceptionContext.CONNECTOR_ACTIVATION_EVENT, (Serializable)((Object)activationEvent));
    }

    public void setConnectorInstanceIdOnContext(long id) {
        this.context.put(ExceptionContext.CONNECTOR_INSTANCE_ID, Long.valueOf(id));
    }

    public void setFlowNodeDefinitionIdOnContext(long id) {
        this.context.put(ExceptionContext.FLOW_NODE_DEFINITION_ID, Long.valueOf(id));
    }

    public void setFlowNodeInstanceIdOnContext(long id) {
        this.context.put(ExceptionContext.FLOW_NODE_INSTANCE_ID, Long.valueOf(id));
    }

    public void setFlowNodeNameOnContext(String name) {
        this.context.put(ExceptionContext.FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    public void setMessageInstanceNameOnContext(String name) {
        this.context.put(ExceptionContext.MESSAGE_INSTANCE_NAME, (Serializable)((Object)name));
    }

    public void setMessageInstanceTargetProcessOnContext(String name) {
        this.context.put(ExceptionContext.MESSAGE_INSTANCE_TARGET_PROCESS_NAME, (Serializable)((Object)name));
    }

    public void setMessageInstanceTargetFlowNodeOnContext(String name) {
        this.context.put(ExceptionContext.MESSAGE_INSTANCE_TARGET_FLOW_NODE_NAME, (Serializable)((Object)name));
    }

    public void setWaitingMessageEventTypeOnContext(String eventType) {
        this.context.put(ExceptionContext.WAITING_MESSAGE_INSTANCE_TYPE, (Serializable)((Object)eventType));
    }

    public void setDocumentIdOnContext(long id) {
        this.context.put(ExceptionContext.DOCUMENT_ID, Long.valueOf(id));
    }

    public void setUserIdOnContext(Long userId) {
        this.context.put(ExceptionContext.USER_ID, userId);
    }

    public void setGroupIdOnContext(Long groupId) {
        this.context.put(ExceptionContext.GROUP_ID, groupId);
    }

    public void setRoleIdOnContext(Long roleId) {
        this.context.put(ExceptionContext.ROLE_ID, roleId);
    }

    public void setDataName(String name) {
        this.context.put(ExceptionContext.DATA_NAME, (Serializable)((Object)name));
    }

    public void setDataClassName(String dataClassName) {
        this.context.put(ExceptionContext.DATA_CLASS_NAME, (Serializable)((Object)dataClassName));
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getUserNameMessage());
        this.appendContextMessage(stringBuilder);
        stringBuilder.append(super.getMessage());
        return stringBuilder.toString();
    }

    private void appendContextMessage(StringBuilder stringBuilder) {
        if (!this.context.isEmpty()) {
            for (Map.Entry<ExceptionContext, Serializable> entry : this.context.entrySet()) {
                stringBuilder.append((Object)((Object)entry.getKey()) + "=" + entry.getValue() + " | ");
            }
        }
    }

    private String getUserNameMessage() {
        return this.userName != null && !this.userName.isEmpty() ? "USERNAME=" + this.userName + " | " : "";
    }
}

