/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.feel.impl.juel.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.camunda.bpm.dmn.feel.impl.juel.FeelLogger;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.camunda.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;

public class NotTransformer
implements FeelToJuelTransformer {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final Pattern NOT_PATTERN = Pattern.compile("^not\\((.+)\\)$");

    @Override
    public boolean canTransform(String feelExpression) {
        return feelExpression.startsWith("not(");
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        String simplePositiveUnaryTests = this.extractInnerExpression(feelExpression);
        String juelExpression = transform.transformSimplePositiveUnaryTests(simplePositiveUnaryTests, inputName);
        return "not(" + juelExpression + ")";
    }

    public String extractInnerExpression(String feelExpression) {
        Matcher matcher = NOT_PATTERN.matcher(feelExpression);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw LOG.invalidNotExpression(feelExpression);
    }
}

