/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.pool;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.darkphoenixs.kafka.core.KafkaMessageNewSender;
import org.darkphoenixs.kafka.core.KafkaMessageSender;
import org.darkphoenixs.kafka.pool.MessageSenderPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class KafkaMessageNewSenderPool<K, V>
implements MessageSenderPool<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageNewSenderPool.class);
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected Properties props = new Properties();
    protected Resource config;
    protected KafkaMessageSender<K, V> sender;
    protected int poolSize;

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
        try {
            PropertiesLoaderUtils.fillProperties((Properties)this.props, (Resource)this.config);
        }
        catch (IOException e) {
            logger.error("Fill properties failed.", (Throwable)e);
        }
    }

    @Override
    public synchronized void init() {
        this.sender = new KafkaMessageNewSender(this.props);
        this.running.set(true);
        logger.info("Message Sender Pool initialized.");
    }

    @Override
    public synchronized void destroy() {
        this.sender.shutDown();
        this.running.set(false);
        logger.info("Message Sender pool closed.");
    }

    @Override
    public synchronized boolean isRunning() {
        return this.running.get();
    }

    @Override
    public KafkaMessageSender<K, V> getSender() {
        if (this.sender == null) {
            this.sender = new KafkaMessageNewSender(this.props);
        }
        return this.sender;
    }

    @Override
    public void returnSender(KafkaMessageSender<K, V> sender) {
    }
}

