/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.mq.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.MQProducerFactory;
import org.darkphoenixs.mq.producer.MQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MQMessageProducerFactory
implements MQProducerFactory {
    private static final AtomicReference<MQMessageProducerFactory> instance = new AtomicReference();
    protected Logger logger = LoggerFactory.getLogger(MQMessageProducerFactory.class);
    private MQProducer<?>[] producers;
    private ConcurrentHashMap<String, MQProducer<?>> producerCache = new ConcurrentHashMap();

    private MQMessageProducerFactory() {
    }

    public static synchronized MQProducerFactory getInstance() {
        if (instance.get() == null) {
            instance.compareAndSet(null, new MQMessageProducerFactory());
        }
        return instance.get();
    }

    public void setProducers(MQProducer<?>[] producers) {
        this.producers = producers;
    }

    @Override
    public <T> void addProducer(MQProducer<T> producer) throws MQException {
        this.producerCache.put(producer.getProducerKey(), producer);
        this.logger.debug("Add MQProducer : " + producer.getProducerKey());
    }

    @Override
    public <T> MQProducer<T> getProducer(String producerKey) throws MQException {
        if (this.producerCache.containsKey(producerKey)) {
            this.logger.debug("Get MQProducer : " + producerKey);
            return this.producerCache.get(producerKey);
        }
        this.logger.warn("Unknown ProducerKey : " + producerKey);
        return null;
    }

    @Override
    public void init() throws MQException {
        if (this.producers != null) {
            for (int i = 0; i < this.producers.length; ++i) {
                this.producerCache.put(this.producers[i].getProducerKey(), this.producers[i]);
            }
        }
        this.logger.debug("Initialized!");
    }

    @Override
    public void destroy() throws MQException {
        if (this.producers != null) {
            this.producers = null;
        }
        if (instance.get() != null) {
            instance.set(null);
        }
        this.producerCache.clear();
        this.logger.debug("Destroyed!");
    }
}

