/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.mq.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.darkphoenixs.mq.consumer.MQConsumer;
import org.darkphoenixs.mq.exception.MQException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQConsumerAdapter<T>
implements MQConsumer<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String consumerKey;

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    @Override
    public void receive(T message) throws MQException {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, ConsumerKey : " + this.getConsumerKey() + " , Message : " + message);
    }

    public void receive(String key, T message) throws MQException {
        try {
            this.doReceive(key, message);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, ConsumerKey : " + this.getConsumerKey() + " , Key : " + key + " , Message : " + message);
    }

    @Override
    public void receive(Map<String, T> messages) throws MQException {
        try {
            this.doReceive(messages);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, ConsumerKey : " + this.getConsumerKey() + " , Messages size: " + messages.size());
    }

    protected abstract void doReceive(T var1) throws MQException;

    protected void doReceive(String key, T message) throws MQException {
        this.doReceive(message);
    }

    protected void doReceive(List<T> messages) throws MQException {
        for (T message : messages) {
            this.doReceive(message);
        }
    }

    protected void doReceive(Map<String, T> messages) throws MQException {
        this.doReceive((List<T>)new ArrayList<T>(messages.values()));
    }
}

