/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.decoration;

import java.io.IOException;
import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.Headers;

public final class ResponseDecorated<T>
implements HttpRequest<T> {
    private final HttpRequest<T> mOriginalRequest;
    private final Decoration<HttpResponse> mResponseDecoration;

    public ResponseDecorated(HttpRequest<T> originalRequest, Decoration<HttpResponse> responseDecoration) {
        this.mOriginalRequest = originalRequest;
        this.mResponseDecoration = responseDecoration;
    }

    public HttpMethod method() {
        return this.mOriginalRequest.method();
    }

    public Headers headers() {
        return this.mOriginalRequest.headers();
    }

    public HttpRequestEntity requestEntity() {
        return this.mOriginalRequest.requestEntity();
    }

    public HttpResponseHandler<T> responseHandler(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        return new HttpResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
                HttpResponse decoratedResponse = ResponseDecorated.this.mResponseDecoration.decorated(response);
                return ResponseDecorated.this.mOriginalRequest.responseHandler(decoratedResponse).handleResponse(decoratedResponse);
            }
        };
    }
}

