/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.QualifiedName;
import org.drools.drl.ast.descr.TypeFieldDescr;

public class TypeDeclarationDescr
extends AbstractClassTypeDeclarationDescr
implements Comparable<TypeDeclarationDescr> {
    private List<QualifiedName> superTypes;
    private boolean trait;

    public TypeDeclarationDescr() {
        this(null);
    }

    public TypeDeclarationDescr(String typeName) {
        super(typeName);
    }

    public TypeDeclarationDescr(String typeName, String typeNamespace) {
        super(typeName, typeNamespace);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.superTypes = (List)in.readObject();
        this.trait = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.superTypes);
        out.writeBoolean(this.trait);
    }

    public String toString() {
        return "TypeDeclaration[ " + this.getType().getFullName() + " ]";
    }

    @Override
    public String getSuperTypeName() {
        return this.superTypes == null ? null : this.superTypes.get(0).getName();
    }

    @Override
    public String getSuperTypeNamespace() {
        return this.superTypes == null ? null : this.superTypes.get(0).getNamespace();
    }

    @Override
    public List<QualifiedName> getSuperTypes() {
        return this.superTypes != null ? this.superTypes : Collections.emptyList();
    }

    public void addSuperType(String type) {
        this.addSuperType(new QualifiedName(type));
    }

    public void addSuperType(QualifiedName type) {
        if (this.superTypes == null) {
            this.superTypes = new ArrayList<QualifiedName>();
        }
        if (!this.superTypes.contains(type)) {
            this.superTypes.add(type);
        }
    }

    @Override
    public int compareTo(TypeDeclarationDescr descr) {
        if (!this.getSuperTypes().isEmpty() && !descr.getSuperTypes().isEmpty()) {
            for (QualifiedName q : descr.getSuperTypes()) {
                if (!this.getSuperTypes().contains(q)) continue;
                return -1;
            }
            for (QualifiedName q : this.getSuperTypes()) {
                if (!descr.getSuperTypes().contains(q)) continue;
                return 1;
            }
        }
        for (TypeFieldDescr field : this.getFields().values()) {
            if (!descr.getTypeName().equals(field.getPattern().getObjectType())) continue;
            return -1;
        }
        for (TypeFieldDescr field : descr.getFields().values()) {
            if (!this.getTypeName().equals(field.getPattern().getObjectType())) continue;
            return 1;
        }
        return 0;
    }

    public boolean isTrait() {
        return this.trait;
    }

    public void setTrait(boolean trait) {
        this.trait = trait;
    }

    @Override
    public void indexByFQN(boolean isStrict) {
        super.indexByFQN(isStrict);
        this.trait |= this.hasAnnotation("org.drools.base.factmodel.traits.Trait");
    }
}

