/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.JdbcUtils;
import org.duckdb.StatementReturnType;

public class DuckDBPreparedStatement
implements PreparedStatement {
    private static Logger logger = Logger.getLogger(DuckDBPreparedStatement.class.getName());
    private DuckDBConnection conn;
    private ByteBuffer stmt_ref = null;
    private DuckDBResultSet select_result = null;
    private int update_result = 0;
    private boolean returnsChangedRows = false;
    private boolean returnsNothing = false;
    private boolean returnsResultSet = false;
    boolean closeOnCompletion = false;
    private Object[] params = new Object[0];
    private DuckDBResultSetMetaData meta = null;
    private final List<Object[]> batchedParams = new ArrayList<Object[]>();
    private final List<String> batchedStatements = new ArrayList<String>();
    private Boolean isBatch = false;
    private Boolean isPreparedStatement = false;

    public DuckDBPreparedStatement(DuckDBConnection conn) throws SQLException {
        if (conn == null) {
            throw new SQLException("connection parameter cannot be null");
        }
        this.conn = conn;
    }

    public DuckDBPreparedStatement(DuckDBConnection conn, String sql) throws SQLException {
        if (conn == null) {
            throw new SQLException("connection parameter cannot be null");
        }
        if (sql == null) {
            throw new SQLException("sql query parameter cannot be null");
        }
        this.conn = conn;
        this.isPreparedStatement = true;
        this.prepare(sql);
    }

    private void startTransaction() throws SQLException {
        if (this.conn.autoCommit || this.conn.transactionRunning) {
            return;
        }
        this.conn.transactionRunning = true;
        try (Statement s = this.conn.createStatement();){
            s.execute("BEGIN TRANSACTION;");
        }
    }

    private void prepare(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (sql == null) {
            throw new SQLException("sql query parameter cannot be null");
        }
        if (this.stmt_ref != null) {
            DuckDBNative.duckdb_jdbc_release(this.stmt_ref);
            this.stmt_ref = null;
        }
        this.meta = null;
        this.params = null;
        if (this.select_result != null) {
            this.select_result.close();
        }
        this.select_result = null;
        this.update_result = 0;
        try {
            this.stmt_ref = DuckDBNative.duckdb_jdbc_prepare(this.conn.conn_ref, sql.getBytes(StandardCharsets.UTF_8));
            this.meta = DuckDBNative.duckdb_jdbc_prepared_statement_meta(this.stmt_ref);
            this.params = new Object[0];
        }
        catch (SQLException e) {
            this.close();
            throw new SQLException(e);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(true);
    }

    private boolean execute(boolean startTransaction) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        ByteBuffer result_ref = null;
        if (this.select_result != null) {
            this.select_result.close();
        }
        this.select_result = null;
        try {
            if (startTransaction) {
                this.startTransaction();
            }
            result_ref = DuckDBNative.duckdb_jdbc_execute(this.stmt_ref, this.params);
            DuckDBResultSetMetaData result_meta = DuckDBNative.duckdb_jdbc_query_result_meta(result_ref);
            this.select_result = new DuckDBResultSet(this, result_meta, result_ref, this.conn.conn_ref);
            this.returnsResultSet = result_meta.return_type.equals((Object)StatementReturnType.QUERY_RESULT);
            this.returnsChangedRows = result_meta.return_type.equals((Object)StatementReturnType.CHANGED_ROWS);
            this.returnsNothing = result_meta.return_type.equals((Object)StatementReturnType.NOTHING);
        }
        catch (SQLException e) {
            if (this.select_result != null) {
                this.select_result.close();
            } else if (result_ref != null) {
                DuckDBNative.duckdb_jdbc_free_result(result_ref);
                result_ref = null;
            }
            this.close();
            throw e;
        }
        if (this.returnsChangedRows) {
            if (this.select_result.next()) {
                this.update_result = this.select_result.getInt(1);
            }
            this.select_result.close();
        }
        return this.returnsResultSet;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.requireNonBatch();
        this.execute();
        if (!this.returnsResultSet) {
            throw new SQLException("executeQuery() can only be used with queries that return a ResultSet");
        }
        return this.select_result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.requireNonBatch();
        this.execute();
        if (!this.returnsChangedRows && !this.returnsNothing) {
            throw new SQLException("executeUpdate() can only be used with queries that return nothing (eg, a DDL statement), or update rows");
        }
        return this.getUpdateCountInternal();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.requireNonBatch();
        this.prepare(sql);
        return this.execute();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.prepare(sql);
        return this.executeQuery();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.prepare(sql);
        return this.executeUpdate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.meta == null) {
            throw new SQLException("Prepare something first");
        }
        return this.meta;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        return this.meta.param_meta;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.getParameterMetaData().getParameterCount()) {
            throw new SQLException("Parameter index out of bounds");
        }
        if (this.params.length == 0) {
            this.params = new Object[this.getParameterMetaData().getParameterCount()];
        }
        this.params[parameterIndex - 1] = x;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.params = new Object[0];
    }

    @Override
    public void close() throws SQLException {
        if (this.select_result != null) {
            this.select_result.close();
            this.select_result = null;
        }
        if (this.stmt_ref != null) {
            DuckDBNative.duckdb_jdbc_release(this.stmt_ref);
            this.stmt_ref = null;
        }
        this.conn = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        logger.log(Level.FINE, "setMaxFieldSize not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.log(Level.FINE, "setQueryTimeout not supported");
    }

    @Override
    public synchronized void cancel() throws SQLException {
        if (this.conn.conn_ref != null) {
            DuckDBNative.duckdb_jdbc_interrupt(this.conn.conn_ref);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCursorName");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        if (!this.returnsResultSet) {
            return null;
        }
        DuckDBResultSet to_return = this.select_result;
        this.select_result = null;
        return to_return;
    }

    private Integer getUpdateCountInternal() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        if (this.returnsResultSet || this.returnsNothing || this.select_result.isFinished()) {
            return -1;
        }
        return this.update_result;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int to_return = this.getUpdateCountInternal();
        this.update_result = -1;
        return to_return;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1000) {
            return;
        }
        throw new SQLFeatureNotSupportedException("setFetchDirection");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return DuckDBNative.duckdb_jdbc_fetch_size();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.requireNonPreparedStatement();
        this.batchedStatements.add(sql);
        this.isBatch = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchedParams.clear();
        this.batchedStatements.clear();
        this.isBatch = false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.isPreparedStatement.booleanValue()) {
                int[] nArray = this.executeBatchedPreparedStatement();
                return nArray;
            }
            int[] nArray = this.executeBatchedStatements();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private int[] executeBatchedPreparedStatement() throws SQLException {
        int[] updateCounts = new int[this.batchedParams.size()];
        this.startTransaction();
        for (int i = 0; i < this.batchedParams.size(); ++i) {
            this.params = this.batchedParams.get(i);
            this.execute(false);
            updateCounts[i] = this.getUpdateCount();
        }
        return updateCounts;
    }

    private int[] executeBatchedStatements() throws SQLException {
        int[] updateCounts = new int[this.batchedStatements.size()];
        this.startTransaction();
        for (int i = 0; i < this.batchedStatements.size(); ++i) {
            this.prepare(this.batchedStatements.get(i));
            this.execute(false);
            updateCounts[i] = this.getUpdateCount();
        }
        return updateCounts;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("getMoreResults");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeUpdate");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("execute");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("execute");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("execute");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSetHoldability");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("setPoolable");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException("isPoolable");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -7: 
            case 16: {
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).byteValue() == 1);
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Boolean.parseBoolean((String)x));
                    break;
                }
                throw new SQLException("Can't convert value to boolean " + x.getClass().toString());
            }
            case -6: {
                if (x instanceof Byte) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).byteValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Byte.parseByte((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to byte " + x.getClass().toString());
            }
            case 5: {
                if (x instanceof Short) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Short.parseShort((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to short " + x.getClass().toString());
            }
            case 4: {
                if (x instanceof Integer) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).intValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Integer.parseInt((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to int " + x.getClass().toString());
            }
            case -5: {
                if (x instanceof Long) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).longValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Long.parseLong((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to long " + x.getClass().toString());
            }
            case 6: 
            case 7: {
                if (x instanceof Float) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, Float.valueOf(((Number)x).floatValue()));
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Float.valueOf(Float.parseFloat((String)x)));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, Float.valueOf((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to float " + x.getClass().toString());
            }
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Double) {
                    this.setObject(parameterIndex, new BigDecimal((Double)x));
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, new BigDecimal((String)x));
                    break;
                }
                throw new SQLException("Can't convert value to double " + x.getClass().toString());
            }
            case 2: 
            case 8: {
                if (x instanceof Double) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof Number) {
                    this.setObject(parameterIndex, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setObject(parameterIndex, Double.parseDouble((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setObject(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to double " + x.getClass().toString());
            }
            case -1: 
            case 1: 
            case 12: {
                if (x instanceof String) {
                    this.setObject(parameterIndex, (String)x);
                    break;
                }
                this.setObject(parameterIndex, x.toString());
                break;
            }
            case 93: 
            case 2014: {
                if (x instanceof Timestamp) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof LocalDateTime) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                if (x instanceof OffsetDateTime) {
                    this.setObject(parameterIndex, x);
                    break;
                }
                throw new SQLException("Can't convert value to timestamp " + x.getClass().toString());
            }
            default: {
                throw new SQLException("Unknown target type " + targetSqlType);
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchedParams.add(this.params);
        this.clearParameters();
        this.isBatch = true;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setArray");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("setDate");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTime");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTimestamp");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNull");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setURL");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNString");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterString");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.setBytes(parameterIndex, JdbcUtils.readAllBytes(x));
        }
        catch (IOException ioe) {
            throw new SQLException("Failed to read from InputStream", ioe);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    private void requireNonBatch() throws SQLException {
        if (this.isBatch.booleanValue()) {
            throw new SQLException("Batched queries must be executed with executeBatch.");
        }
    }

    private void requireNonPreparedStatement() throws SQLException {
        if (this.isPreparedStatement.booleanValue()) {
            throw new SQLException("Cannot add batched SQL statement to PreparedStatement");
        }
    }
}

