/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tahu.message.model.Value;

public class Row {
    private List<Value<?>> values;

    public Row() {
        this.values = new ArrayList();
    }

    public Row(List<Value<?>> values) {
        this.values = values;
    }

    public Row(Row row) {
        this.values = new ArrayList();
        if (row != null && row.getValues() != null) {
            for (Value<?> value : row.getValues()) {
                this.values.add(new Value(value));
            }
        }
    }

    public List<Value<?>> getValues() {
        return this.values;
    }

    public void setValues(List<Value<?>> values) {
        this.values = values;
    }

    public void addValue(Value<?> value) {
        this.values.add(value);
    }

    public String toString() {
        return "Row [values=" + this.values + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public static List<Object> toValues(Row row) {
        ArrayList<Object> list = new ArrayList<Object>(row.getValues().size());
        for (Value<?> value : row.getValues()) {
            list.add(value.getValue());
        }
        return list;
    }

    public static class RowBuilder {
        private List<Value<?>> values;

        public RowBuilder() {
            this.values = new ArrayList();
        }

        public RowBuilder(Row row) {
            this.values = new ArrayList(row.getValues());
        }

        public RowBuilder addValue(Value<?> value) {
            this.values.add(value);
            return this;
        }

        public RowBuilder addValues(Collection<Value<?>> values) {
            this.values.addAll(values);
            return this;
        }

        public Row createRow() {
            return new Row(this.values);
        }
    }
}

