/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;
import org.eclipse.tycho.p2maven.transport.TransportProtocolHandler;

@Component(role=TransportProtocolHandler.class, hint="ftp")
public class FtpTransportProtocolHandler
implements TransportProtocolHandler,
Disposable {
    private static final int FTP_DEFAULT_PORT = Integer.getInteger("tycho.p2.transport.ftp.port", 21);
    private static final Map<String, FTPClient> CLIENTS = new ConcurrentHashMap<String, FTPClient>(8);
    @Requirement
    private Logger logger;
    @Requirement
    private TransportCacheConfig cacheConfig;
    @Requirement
    private MavenAuthenticator authenticator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastModified(URI uri) throws IOException {
        FTPClient client;
        FTPClient fTPClient = client = this.getClient(uri);
        synchronized (fTPClient) {
            if (!client.hasFeature(FTPCmd.MDTM)) {
                this.logger.debug("Could not retrieve the last modification timestamp for: " + uri);
                return -1L;
            }
            FTPFile file = client.mdtmFile(uri.getPath());
            if (file == null) {
                throw new FileNotFoundException("Could not find file: " + uri);
            }
            return file.getTimestampInstant().toEpochMilli();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile(URI uri) throws IOException {
        FTPClient client;
        File localFile = this.getLocalFile(uri);
        if (this.cacheConfig.isOffline()) {
            if (!localFile.isFile()) {
                throw new IOException("Maven is offline and the requested file does not exist locally: " + uri);
            }
            return localFile;
        }
        FTPClient fTPClient = client = this.getClient(uri);
        synchronized (fTPClient) {
            boolean isRemoteMissing;
            String remotePath = uri.getPath();
            FTPFile remoteFile = this.getRemoteFileInfo(client, remotePath);
            boolean bl = isRemoteMissing = remoteFile == null;
            if (localFile.isFile() && (isRemoteMissing || !this.mustRefresh(localFile, remoteFile))) {
                return localFile;
            }
            if (isRemoteMissing) {
                throw new FileNotFoundException("Could not find file: " + uri);
            }
            File parent = FileUtils.createParentDirectories((File)localFile);
            File tempFile = Files.createTempFile(parent.toPath(), "download", ".tmp", new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(tempFile);){
                if (!client.retrieveFile(remotePath, (OutputStream)os)) {
                    String message = client.getReplyString();
                    throw new IOException(String.format("Error retrieving file: %s. Message: %s", remotePath, message));
                }
            }
            catch (IOException e) {
                tempFile.delete();
                throw e;
            }
            if (localFile.isFile()) {
                FileUtils.forceDelete((File)localFile);
            }
            FileUtils.moveFile((File)tempFile, (File)localFile);
            localFile.setLastModified(remoteFile.getTimestampInstant().toEpochMilli());
            return localFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        for (Map.Entry<String, FTPClient> entry : CLIENTS.entrySet()) {
            FTPClient client = entry.getValue();
            try {
                FTPClient fTPClient = client;
                synchronized (fTPClient) {
                    if (client.isAvailable()) {
                        client.logout();
                        client.disconnect();
                    }
                }
            }
            catch (FTPConnectionClosedException fTPConnectionClosedException) {
            }
            catch (IOException e) {
                this.logger.debug("Error disconnecting from host: " + entry.getKey(), (Throwable)e);
            }
        }
    }

    protected FTPClient createFtpClient() {
        FTPClient client = new FTPClient();
        client.setControlKeepAliveTimeout(Duration.ofSeconds(15L));
        client.setAutodetectUTF8(true);
        client.setBufferSize(8192);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FTPClient getClient(URI uri) throws IOException {
        FTPClient client;
        String host = uri.getHost();
        int port = uri.getPort() < 0 ? FTP_DEFAULT_PORT : uri.getPort();
        String key = host + ":" + port;
        FTPClient fTPClient = client = CLIENTS.computeIfAbsent(key, k -> this.createFtpClient());
        synchronized (fTPClient) {
            try {
                if (client.isAvailable() && client.sendNoOp()) {
                    return client;
                }
            }
            catch (FTPConnectionClosedException e) {
                this.logger.debug(String.format("Connection to host %s was closed, reconnecting", key));
            }
            catch (SocketException e) {
                this.logger.debug(String.format("Socket connection error for host %s, reconnecting", key), (Throwable)e);
            }
            client.disconnect();
            client.connect(host, port);
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                String message = client.getReplyString();
                client.disconnect();
                throw new IOException(String.format("Could not connect to host: %s. Message: %s", key, message));
            }
            MavenRepositorySettings.Credentials credentials = this.authenticator.getServerCredentials(uri);
            if (credentials != null) {
                client.login(credentials.getUserName(), credentials.getPassword());
            } else {
                client.login("anonymous", "");
            }
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                String message = client.getReplyString();
                client.disconnect();
                throw new IOException(String.format("Could not login to host: %s. Message: %s", key, message));
            }
            client.enterLocalPassiveMode();
            client.setFileType(2);
            return client;
        }
    }

    private File getLocalFile(URI uri) {
        File cacheLocation = this.cacheConfig.getCacheLocation();
        String path = uri.normalize().toASCIIString().replace(':', '/').replace('@', '/').replaceAll("/+", "/");
        return new File(cacheLocation, path);
    }

    private FTPFile getRemoteFileInfo(FTPClient client, String path) throws IOException {
        FTPFile file;
        if (client.hasFeature(FTPCmd.MLST)) {
            return client.mlistFile(path);
        }
        if (client.hasFeature(FTPCmd.MDTM) && (file = client.mdtmFile(path)) != null) {
            String size = client.getSize(path);
            file.setSize(size != null ? Long.parseLong(size) : -1L);
            return file;
        }
        return null;
    }

    private boolean mustRefresh(File localFile, FTPFile remoteFile) {
        return this.cacheConfig.isUpdate() || localFile.lastModified() < remoteFile.getTimestampInstant().toEpochMilli() || localFile.length() != remoteFile.getSize();
    }
}

