/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

public interface Headers
extends AutoCloseable {
    public static final String ENCODING_IDENTITY = "identity";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ETAG_HEADER = "ETag";
    public static final String LAST_MODIFIED_HEADER = "Last-Modified";
    public static final String EXPIRES_HEADER = "Expires";
    public static final String CACHE_CONTROL_HEADER = "Cache-Control";
    public static final String MAX_AGE_DIRECTIVE = "max-age";
    public static final String MUST_REVALIDATE_DIRECTIVE = "must-revalidate";

    public int statusCode() throws IOException;

    public Map<String, List<String>> headers();

    @Override
    public void close();

    public URI getURI();

    public String getHeader(String var1);

    public long getLastModified();

    default public void checkResponseCode() throws FileNotFoundException, IOException {
        int code = this.statusCode();
        if (code >= 400) {
            if (code == 404 || code == 410) {
                throw new FileNotFoundException(this.getURI().toString());
            }
            throw new IOException("Server returned HTTP code: " + code + " for URL " + this.getURI().toString());
        }
    }
}

