/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=MavenPropertyHelper.class)
public class MavenPropertyHelper {
    @Requirement
    LegacySupport legacySupport;

    public String getGlobalProperty(String key) {
        return this.getGlobalProperty(key, null);
    }

    public String getGlobalProperty(String key, String defaultValue) {
        MavenSession mavenSession = this.legacySupport.getSession();
        if (mavenSession != null) {
            Properties userProperties = mavenSession.getUserProperties();
            String userProperty = userProperties.getProperty(key);
            if (userProperty != null) {
                return userProperty;
            }
            Settings settings = mavenSession.getSettings();
            List profiles = settings.getProfiles();
            List activeProfiles = settings.getActiveProfiles();
            for (Profile profile : profiles) {
                String profileProperty;
                if (!activeProfiles.contains(profile.getId()) || (profileProperty = profile.getProperties().getProperty(key)) == null) continue;
                return profileProperty;
            }
            Properties systemProperties = mavenSession.getSystemProperties();
            String systemProperty = systemProperties.getProperty(key);
            if (systemProperty != null) {
                return systemProperty;
            }
        }
        return System.getProperty(key, defaultValue);
    }
}

