/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;

public interface InstallableUnitProvider {
    public Collection<IInstallableUnit> getInstallableUnits(MavenProject var1, MavenSession var2) throws CoreException;

    public static Collection<IInstallableUnit> createIU(Stream<IRequirement> requirements, String idPrefix) {
        return InstallableUnitProvider.createIU(requirements.toList(), idPrefix);
    }

    public static Collection<IInstallableUnit> createIU(Collection<IRequirement> requirements, String idPrefix) {
        if (requirements.isEmpty()) {
            return Collections.emptyList();
        }
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        result.setId(idPrefix + "-" + UUID.randomUUID());
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)String.valueOf(System.currentTimeMillis())));
        result.addRequirements(requirements);
        return List.of(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result));
    }
}

