/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.FacebookException;
import facebook4j.RawAPIResponse;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

final class RawAPIResponseImpl
implements RawAPIResponse,
Serializable {
    private static final long serialVersionUID = 8389958738540393505L;
    private final String responseAsString;
    private final JSONObject jsonObject;
    private final JSONArray jsonArray;
    private final Boolean bool;

    RawAPIResponseImpl(HttpResponse res) throws FacebookException {
        this.responseAsString = res.asString();
        if (this.responseAsString.startsWith("{")) {
            this.jsonObject = res.asJSONObject();
            this.jsonArray = null;
            this.bool = null;
        } else if (this.responseAsString.startsWith("[")) {
            this.jsonObject = null;
            this.jsonArray = res.asJSONArray();
            this.bool = null;
        } else {
            this.jsonObject = null;
            this.jsonArray = null;
            this.bool = Boolean.valueOf(this.responseAsString.trim());
        }
    }

    public boolean isJSONObject() {
        return this.jsonObject != null;
    }

    public boolean isJSONArray() {
        return this.jsonArray != null;
    }

    public boolean isBoolean() {
        return this.bool != null;
    }

    public JSONObject asJSONObject() throws FacebookException {
        return this.jsonObject;
    }

    public JSONArray asJSONArray() throws FacebookException {
        return this.jsonArray;
    }

    public boolean asBoolean() throws FacebookException {
        return this.bool;
    }

    public String asString() {
        return this.responseAsString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RawAPIResponseImpl)) {
            return false;
        }
        RawAPIResponseImpl that = (RawAPIResponseImpl)o;
        return !(this.responseAsString != null ? !this.responseAsString.equals(that.responseAsString) : that.responseAsString != null);
    }

    public int hashCode() {
        return this.responseAsString != null ? this.responseAsString.hashCode() : 0;
    }

    public String toString() {
        return "RawAPIResponseImpl{responseAsString='" + this.responseAsString + '\'' + '}';
    }
}

