/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Privacy;
import facebook4j.PrivacyType;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrivacyJSONImpl
implements Privacy,
Serializable {
    private static final long serialVersionUID = -3272219269372534734L;
    private PrivacyType value;
    private PrivacyType friends;
    private List<String> networks;
    private List<String> allow;
    private List<String> deny;
    private List<String> description;

    public PrivacyJSONImpl(JSONObject json) throws FacebookException {
        String descriptionString;
        String denyString;
        String allowString;
        String networksString;
        this.value = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("value", json));
        this.friends = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("friends", json));
        this.networks = new ArrayList<String>();
        if (!json.isNull("networks") && !(networksString = z_F4JInternalParseUtil.getRawString("networks", json)).equals("")) {
            String[] networksArray;
            for (String network : networksArray = networksString.split(",")) {
                this.networks.add(network.trim());
            }
        }
        this.allow = new ArrayList<String>();
        if (!json.isNull("allow") && !(allowString = z_F4JInternalParseUtil.getRawString("allow", json)).equals("")) {
            String[] allowArray;
            for (String _allow : allowArray = allowString.split(",")) {
                this.allow.add(_allow.trim());
            }
        }
        this.deny = new ArrayList<String>();
        if (!json.isNull("deny") && !(denyString = z_F4JInternalParseUtil.getRawString("deny", json)).equals("")) {
            String[] denyArray;
            for (String _deny : denyArray = denyString.split(",")) {
                this.deny.add(_deny.trim());
            }
        }
        this.description = new ArrayList<String>();
        if (!json.isNull("description") && !(descriptionString = z_F4JInternalParseUtil.getRawString("description", json)).equals("")) {
            String[] descriptionArray;
            for (String _description : descriptionArray = descriptionString.split(",")) {
                this.description.add(_description.trim());
            }
        }
    }

    @Override
    public PrivacyType getValue() {
        return this.value;
    }

    @Override
    public PrivacyType getFriends() {
        return this.friends;
    }

    @Override
    public List<String> getNetworks() {
        return this.networks;
    }

    @Override
    public List<String> getAllow() {
        return this.allow;
    }

    @Override
    public List<String> getDeny() {
        return this.deny;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    public String toString() {
        return "PrivacyJSONImpl [value=" + (Object)((Object)this.value) + ", friends=" + (Object)((Object)this.friends) + ", networks=" + this.networks + ", allow=" + this.allow + ", deny=" + this.deny + ", description=" + this.description + "]";
    }
}

