/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.Descriptor;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.MultiMap;

public class EventPublishingInhabitant<T>
extends AbstractInhabitantImpl<T> {
    protected volatile Inhabitant<T> real;
    private volatile CopyOnWriteArraySet<InhabitantListener> listeners;

    public EventPublishingInhabitant(Descriptor descriptor) {
        super(descriptor);
        this.real = null;
    }

    public EventPublishingInhabitant(Inhabitant<?> delegate) {
        this(delegate, null);
    }

    public EventPublishingInhabitant(Inhabitant<?> delegate, InhabitantListener listener) {
        super(EventPublishingInhabitant.getDescriptorFor(delegate));
        this.real = delegate;
        if (null != listener) {
            this.addInhabitantListener(listener);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.typeName() + ", active: " + this.real + ")";
    }

    @Override
    public String typeName() {
        return null == this.real ? null : this.real.typeName();
    }

    @Override
    public MultiMap<String, String> metadata() {
        return null == this.real ? null : this.real.metadata();
    }

    @Override
    public void release() {
        boolean wasActive = this.isActive();
        if (null != this.real) {
            this.real.release();
        }
        if (wasActive && !this.isActive()) {
            this.notify(InhabitantListener.EventType.INHABITANT_RELEASED);
        }
    }

    public boolean isActive() {
        return null != this.real && this.real.isActive();
    }

    @Override
    public Class<? extends T> type() {
        if (null == this.real) {
            throw new IllegalStateException();
        }
        boolean wasActive = this.real.isActive();
        Class<T> t = this.real.type();
        if (!wasActive && this.real.isActive()) {
            this.notify(InhabitantListener.EventType.INHABITANT_ACTIVATED);
        }
        return t;
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        if (null == this.real) {
            this.fetch();
        }
        boolean wasActive = this.real.isActive();
        T result = this.real.get(onBehalfOf);
        Inhabitant<T> real = this.real;
        if (!wasActive && null != real && real.isActive()) {
            this.notify(InhabitantListener.EventType.INHABITANT_ACTIVATED);
        }
        return result;
    }

    protected void fetch() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInhabitantListener(InhabitantListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException();
        }
        if (null == this.listeners) {
            EventPublishingInhabitant eventPublishingInhabitant = this;
            synchronized (eventPublishingInhabitant) {
                if (null == this.listeners) {
                    this.listeners = new CopyOnWriteArraySet();
                }
            }
        }
        this.listeners.add(listener);
    }

    public boolean removeInhabitantListener(InhabitantListener listener) {
        return null == this.listeners ? false : this.listeners.remove(listener);
    }

    protected void notify(InhabitantListener.EventType eventType) {
        if (null != this.listeners) {
            for (InhabitantListener listener : this.listeners) {
                try {
                    boolean keepListening = listener.inhabitantChanged(eventType, this);
                    if (keepListening) continue;
                    this.removeInhabitantListener(listener);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from listener", e);
                }
            }
        }
    }
}

