/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.jvnet.hk2.component.InjectionPoint;

public final class Hk2ThreadContext {
    private static final ThreadLocal<Hk2ThreadContext> tlc = new ThreadLocal();
    private AccessControlContext acc;
    private Stack<InjectionPoint> injectionPoints = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void captureACCandRun(Runnable runnable) {
        boolean created;
        Hk2ThreadContext ts = tlc.get();
        if (null != ts && null != ts.acc) {
            runnable.run();
            return;
        }
        boolean bl = created = null == ts;
        if (created) {
            ts = new Hk2ThreadContext();
            tlc.set(ts);
        }
        ts.acc = AccessController.getContext();
        try {
            runnable.run();
        }
        finally {
            ts.acc = null;
            if (created) {
                tlc.set(null);
            }
        }
    }

    static AccessControlContext getCallerACC() {
        Hk2ThreadContext ts = tlc.get();
        return null == ts ? null : ts.acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> V captureIPandRun(InjectionPoint ip, Callable<V> callable) throws Exception {
        boolean created;
        Hk2ThreadContext ts = tlc.get();
        boolean bl = created = null == ts;
        if (created) {
            ts = new Hk2ThreadContext();
            tlc.set(ts);
        }
        ts.injectionPoints.push(ip);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            ts.injectionPoints.pop();
            if (created) {
                tlc.set(null);
            }
        }
    }

    static InjectionPoint getCallerIP() {
        Hk2ThreadContext ts = tlc.get();
        try {
            return null == ts ? null : ts.injectionPoints.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }
}

