/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.PreDestroy;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.ScopeInstance;

public final class ScopeInstanceImpl
implements ScopeInstance,
PreDestroy {
    private static final Logger logger = Logger.getLogger(ScopeInstanceImpl.class.getName());
    public final String name;
    private final Map backend;

    public ScopeInstanceImpl(String name, Map backend) {
        this.name = name;
        this.backend = backend;
    }

    public ScopeInstanceImpl(Map backend) {
        this.name = super.toString();
        this.backend = backend;
    }

    public String toString() {
        return this.name;
    }

    public <T> T get(Provider<T> inhabitant) {
        return (T)this.backend.get(inhabitant);
    }

    public <T> T put(Provider<T> inhabitant, T value) {
        return this.backend.put(inhabitant, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map map = this.backend;
        synchronized (map) {
            for (Object o : this.backend.values()) {
                if (!(o instanceof PreDestroy)) continue;
                logger.log(Level.FINER, "calling PreDestroy on {0}", o);
                ((PreDestroy)o).preDestroy();
            }
            this.backend.clear();
        }
    }

    public void preDestroy() {
        this.release();
    }
}

