/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.FactoryCreator;
import com.sun.hk2.component.InjectableParametizedConstructorCreator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.inject.Inject;
import org.jvnet.hk2.annotations.Factory;
import org.jvnet.hk2.annotations.FactoryFor;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Reference;

public class Creators {
    public static <T> Creator<T> create(Class<T> c, Habitat habitat, MultiMap<String, String> metadata) {
        Factory f = c.getAnnotation(Factory.class);
        if (f != null) {
            return new FactoryCreator<T>(c, f.value(), habitat, metadata);
        }
        Inhabitant<?> factory = habitat.getInhabitantByAnnotation(FactoryFor.class, c.getName());
        if (factory != null) {
            return new FactoryCreator<T>(c, factory, habitat, metadata);
        }
        Reference<Constructor<T>> defaultCtorRef = new Reference<Constructor<T>>();
        Reference<Constructor<T>> noArgCtorRef = new Reference<Constructor<T>>();
        Creators.qualifyingConstructors(c, null, defaultCtorRef, noArgCtorRef);
        if (defaultCtorRef.get() != null) {
            return new InjectableParametizedConstructorCreator<T>(c, defaultCtorRef.get(), habitat, metadata);
        }
        if (noArgCtorRef.get() != null) {
            return new ConstructorCreator<T>(c, habitat, metadata);
        }
        return null;
    }

    public static <T> void qualifyingConstructors(Class<T> c, List<Constructor<?>> allList, Reference<Constructor<T>> defaultCtor, Reference<Constructor<T>> noArgCtor) {
        Constructor<?>[] ctors;
        try {
            ctors = c.getDeclaredConstructors();
        }
        catch (Exception e) {
            ctors = c.getConstructors();
        }
        for (Constructor<?> ctor : ctors) {
            if (0 == ctor.getParameterTypes().length) {
                if (null != allList) {
                    allList.add(ctor);
                }
                if (null == noArgCtor) continue;
                noArgCtor.set(ctor);
                continue;
            }
            if (Creators.isInjectable(ctor)) {
                if (null != allList) {
                    allList.add(ctor);
                }
                if (null == defaultCtor || null != defaultCtor.get()) continue;
                defaultCtor.set(ctor);
                continue;
            }
            boolean allInjectable = true;
            for (Annotation[] a : ctor.getParameterAnnotations()) {
                if (Creators.isInject(a)) continue;
                allInjectable = false;
                break;
            }
            if (!allInjectable) continue;
            if (null != allList) {
                allList.add(ctor);
            }
            if (null == defaultCtor || null != defaultCtor.get()) continue;
            defaultCtor.set(ctor);
        }
    }

    private static boolean isInject(Annotation ... a) {
        for (Annotation ae : a) {
            if (!ae.annotationType().equals(org.jvnet.hk2.annotations.Inject.class) && !ae.annotationType().equals(Inject.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInjectable(AnnotatedElement ae) {
        return null != ae.getAnnotation(org.jvnet.hk2.annotations.Inject.class) || null != ae.getAnnotation(Inject.class);
    }
}

