/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers;

public enum RevisionType {
    ADD(0),
    MOD(1),
    DEL(2);

    private Byte representation;

    private RevisionType(byte representation) {
        this.representation = representation;
    }

    public Byte getRepresentation() {
        return this.representation;
    }

    public static RevisionType fromRepresentation(Object representation) {
        if (!(representation instanceof Byte)) {
            return null;
        }
        return RevisionType.fromRepresentation((Byte)representation);
    }

    public static RevisionType fromRepresentation(byte representation) {
        switch (representation) {
            case 0: {
                return ADD;
            }
            case 1: {
                return MOD;
            }
            case 2: {
                return DEL;
            }
        }
        throw new IllegalArgumentException("Unknown representation: " + representation);
    }
}

