/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.constantine.platform.Errno;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseHeapFileStat;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibCProvider;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Solaris64FileStat;
import org.jruby.ext.posix.SolarisHeapFileStat;
import org.jruby.ext.posix.SolarisPasswd;
import org.jruby.ext.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new SolarisPasswd((Pointer)arg) : null;
        }
    };

    SolarisPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public BaseHeapFileStat allocateStat() {
        return Platform.IS_32_BIT ? new SolarisHeapFileStat(this) : new Solaris64FileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_64_BIT ? this.libc().fstat(fd, stat) : this.libc().fstat64(fd, stat)) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    public int lchmod(String filename, int mode) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public FileStat lstat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().lstat(path, stat) : this.libc().lstat64(path, stat)) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().stat(path, stat) : this.libc().stat64(path, stat)) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }
}

