/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.InputStream;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.parser.LiquibaseParser;
import liquibase.parser.NamespaceDetails;
import liquibase.parser.NamespaceDetailsFactory;
import liquibase.parser.core.xml.ClassLoaderXsdStreamResolver;
import liquibase.parser.core.xml.ContextClassLoaderXsdStreamResolver;
import liquibase.parser.core.xml.ResourceAccessorXsdStreamResolver;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializer;
import org.xml.sax.InputSource;

class LiquibaseSchemaResolver {
    private static final Logger LOGGER = LogService.getLog(LiquibaseSchemaResolver.class);
    private String systemId;
    private String publicId;
    private ResourceAccessorXsdStreamResolver resourceAccessorXsdStreamResolver;
    private ContextClassLoaderXsdStreamResolver contextClassLoaderXsdStreamResolver;
    private ClassLoaderXsdStreamResolver classLoaderXsdStreamResolver;

    public LiquibaseSchemaResolver(String systemId, String publicId, ResourceAccessor resourceAccessor) {
        this.systemId = systemId;
        this.publicId = publicId;
        this.resourceAccessorXsdStreamResolver = new ResourceAccessorXsdStreamResolver(resourceAccessor);
        this.contextClassLoaderXsdStreamResolver = new ContextClassLoaderXsdStreamResolver();
        this.classLoaderXsdStreamResolver = new ClassLoaderXsdStreamResolver();
        this.resourceAccessorXsdStreamResolver.setSuccessor(this.contextClassLoaderXsdStreamResolver);
        this.contextClassLoaderXsdStreamResolver.setSuccessor(this.classLoaderXsdStreamResolver);
    }

    public InputSource resolve(LiquibaseSerializer serializer) {
        if (serializer == null) {
            throw new RuntimeException("Serializer can not be null");
        }
        NamespaceDetails namespaceDetails = NamespaceDetailsFactory.getInstance().getNamespaceDetails(serializer, this.systemId);
        return this.getInputSourceFromXsd(namespaceDetails);
    }

    public InputSource resolve(LiquibaseParser parser) {
        if (parser == null) {
            throw new RuntimeException("Parser can not be null");
        }
        NamespaceDetails namespaceDetails = NamespaceDetailsFactory.getInstance().getNamespaceDetails(parser, this.systemId);
        return this.getInputSourceFromXsd(namespaceDetails);
    }

    private InputSource getInputSourceFromXsd(NamespaceDetails namespaceDetails) {
        if (this.systemId == null) {
            return null;
        }
        LOGGER.debug(LogType.LOG, "Found namespace details class " + namespaceDetails.getClass().getName() + " for " + this.systemId);
        String xsdFile = namespaceDetails.getLocalPath(this.systemId);
        LOGGER.debug(LogType.LOG, "Local path for " + this.systemId + " is " + xsdFile);
        if (xsdFile == null) {
            return null;
        }
        try {
            InputStream resourceAsStream = this.resourceAccessorXsdStreamResolver.getResourceAsStream(xsdFile);
            if (resourceAsStream == null) {
                LOGGER.debug(LogType.LOG, "Could not find " + xsdFile + " locally");
                return null;
            }
            LOGGER.debug(LogType.LOG, "Successfully loaded XSD from " + xsdFile);
            InputSource source = new InputSource(resourceAsStream);
            source.setPublicId(this.publicId);
            source.setSystemId(this.systemId);
            return source;
        }
        catch (Exception ex2) {
            LOGGER.debug(LogType.LOG, "Error loading XSD", ex2);
            return null;
        }
    }
}

