/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import liquibase.FileOpener;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseUpdateMojo;

public class LiquibaseMigrateSQL
extends AbstractLiquibaseUpdateMojo {
    protected File migrationSqlOutputFile;
    private Writer outputWriter;

    public void configureFieldsAndValues(FileOpener fo) throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"This plugin goal is DEPRICATED and will bre removed in a future release, please use \"updateSQL\" instead of \"migrateSQL\".");
        super.configureFieldsAndValues(fo);
    }

    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }

    protected void doUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.changesToApply > 0) {
            liquibase.update(this.changesToApply, this.contexts, this.outputWriter);
        } else {
            liquibase.update(this.contexts, this.outputWriter);
        }
    }

    protected Liquibase createLiquibase(FileOpener fo, Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(fo, db);
        try {
            if (!this.migrationSqlOutputFile.exists()) {
                this.migrationSqlOutputFile.getParentFile().mkdirs();
                if (!this.migrationSqlOutputFile.createNewFile()) {
                    throw new MojoExecutionException("Cannot create the migration SQL file; " + this.migrationSqlOutputFile.getAbsolutePath());
                }
            }
            this.outputWriter = new FileWriter(this.migrationSqlOutputFile);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create SQL output writer", (Exception)e);
        }
        this.getLog().info((CharSequence)("Output SQL Migration File: " + this.migrationSqlOutputFile.getAbsolutePath()));
        return liquibase;
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "migrationSQLOutputFile: " + this.migrationSqlOutputFile));
    }

    protected void cleanup(Database db) {
        super.cleanup(db);
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }
}

