/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.jdbc.oracore.Util;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.xdb.RealInputStream;
import oracle.xdb.XDBError;
import oracle.xdb.XMLTypeFactory;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.spi.XDBContext;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLType
extends OPAQUE
implements ORAData {
    public static final int _SQL_TYPECODE = 2007;
    public static final String _SQL_TYPENAME = "SYS.XMLTYPE";
    private static final int CONNTYPE_THIN = 0;
    private static final int CONNTYPE_OCI8 = 1;
    private static final int CONNTYPE_KPRB = 2;
    int m_conntype;
    long m_gpCState = 0L;
    String m_stringval = null;
    ByteArrayOutputStream m_bytesval = null;
    CLOB m_clobval = null;
    long m_cstate = 0L;
    OracleConnection m_local_conn;
    Document m_dom = null;
    CharacterSet m_charSet = CharacterSet.make((int)-1);
    private boolean m_isClosed = false;
    private static boolean m_libLoaded = false;
    private static final XMLTypeFactory xmlfactory = new XMLTypeFactory();
    static final int XMLTYPE_VERSION = 1;
    static final int XMLTYPE_LOB = 1;
    static final int XMLTYPE_STR = 4;
    static final int XMLTYPE_PTR = 8;

    public XMLType() throws SQLException {
        super(null, null, (Object)new byte[1]);
    }

    private XMLType(Connection connection, long l) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        this.m_cstate = l;
    }

    public XMLType(Connection connection, InputStream inputStream) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (inputStream == null) {
            return;
        }
        byte[] byArray = new byte[1024];
        switch (this.m_conntype) {
            case 0: {
                this.m_bytesval = new ByteArrayOutputStream();
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        this.m_bytesval.write(byArray, 0, n);
                    }
                    break;
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
            }
            case 1: 
            case 2: {
                try {
                    long l = 0L;
                    try {
                        int n;
                        int n2 = 0;
                        while ((n = inputStream.read(byArray)) != -1) {
                            l = this.WriteToSegStreamNative(this.m_gpCState, this.getErrHandle(), l, byArray, n2, n);
                            n2 += byArray.length;
                        }
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                    this.m_cstate = this.createXMLTypeFromStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), l);
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_bytesval = new ByteArrayOutputStream();
                    try {
                        int n;
                        while ((n = inputStream.read(byArray)) != -1) {
                            this.m_bytesval.write(byArray, 0, n);
                        }
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                }
            }
        }
    }

    public XMLType(Connection connection, String string) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (string == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_stringval = string;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), string, null, false, false);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_stringval = string;
                }
                break;
            }
        }
    }

    public XMLType(Connection connection, String string, String string2, boolean bl, boolean bl2) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (string == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_stringval = string;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), string, string2, bl, bl2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_stringval = string;
                }
                break;
            }
        }
    }

    public XMLType(Connection connection, CLOB cLOB) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (cLOB == null) {
            return;
        }
        this.getCStateFromLocator(cLOB);
    }

    public XMLType(Connection connection, CLOB cLOB, String string, boolean bl, boolean bl2) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (cLOB == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_clobval = cLOB;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), cLOB.getLocator(), string, bl, bl2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_clobval = cLOB;
                }
                break;
            }
        }
    }

    public XMLType(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        super(opaqueDescriptor, connection, object == null ? (Object)new byte[1] : object);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (object == null) {
            return;
        }
        byte[] byArray = (byte[])object;
        int n = 0;
        switch (this.m_conntype) {
            case 0: {
                this.processThin(byArray, n);
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.processCState(byArray, n);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.processThin(byArray, 0);
                    this.m_cstate = 0L;
                }
                break;
            }
        }
    }

    private synchronized native long WriteToSegStreamNative(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    private static int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 24;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 16;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 8;
        return n2 += XMLType.unsignedByteToInt(byArray[n++]);
    }

    public void close() {
        this.freeXMLType();
    }

    private synchronized native void closeNative(long var1, long var3, long var5, long var7);

    public XMLType createSchemaBasedXML(String string) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return new XMLType((Connection)this.m_local_conn, this.getClobVal(), string, false, false);
    }

    public static XMLType createXML(Connection connection, InputStream inputStream) throws SQLException {
        return new XMLType(connection, inputStream);
    }

    public static XMLType createXML(Connection connection, String string) throws SQLException {
        return new XMLType(connection, string);
    }

    public static XMLType createXML(Connection connection, String string, String string2, boolean bl, boolean bl2) throws SQLException {
        return new XMLType(connection, string, string2, bl, bl2);
    }

    public static XMLType createXML(Connection connection, CLOB cLOB) throws SQLException {
        return new XMLType(connection, cLOB);
    }

    public static XMLType createXML(Connection connection, CLOB cLOB, String string, boolean bl, boolean bl2) throws SQLException {
        return new XMLType(connection, cLOB, string, bl, bl2);
    }

    public static XMLType createXML(Connection connection, Document document) throws SQLException {
        if (document instanceof XDBDocument) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            if (((OracleConnection)connection).getProtocolType().equals("kprb")) {
                l = XDBContext.getServerEnv();
            } else {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)((OracleConnection)connection).getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                l2 = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                l3 = Long.parseLong(properties.getProperty("OCIErrHandle"));
            }
            long l4 = XMLType.getXMLTypeFromXobd(l, l2, l3, ((XDBDocument)document).toCState());
            XMLType xMLType = new XMLType(connection, l4);
            return xMLType;
        }
        if (document instanceof XMLDocument) {
            Object object;
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            try {
                object = new PrintWriter(cLOB.getCharacterOutputStream());
                ((XMLDocument)document).print(object);
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
            object = XMLType.createXML(connection, cLOB);
            return object;
        }
        return null;
    }

    public static XMLType createXML(OPAQUE oPAQUE) throws SQLException {
        String string = oPAQUE.getSQLTypeName();
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        SQLName.setHandleDoubleQuote((boolean)true);
        SQLName.parse((String)string, (String[])stringArray, (String[])stringArray2);
        if (stringArray2[0].compareTo("XMLTYPE") != 0) {
            return null;
        }
        return new XMLType(oPAQUE.getDescriptor(), oPAQUE.getJavaSqlConnection(), oPAQUE.getBytesValue());
    }

    private synchronized native long createXMLTypeFromLobNative(long var1, long var3, long var5, byte[] var7, String var8, boolean var9, boolean var10);

    private synchronized native long createXMLTypeFromStreamNative(long var1, long var3, long var5, long var7);

    private synchronized native long createXMLTypeFromStringNative(long var1, long var3, long var5, String var7, String var8, boolean var9, boolean var10);

    public boolean existsNode(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean bl = this.existsNodeNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, string, string2);
        return bl;
    }

    private synchronized native boolean existsNodeNative(long var1, long var3, long var5, String var7, String var8);

    public XMLType extract(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long l = this.extractNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, string, string2);
        if (l != 0L) {
            return new XMLType((Connection)this.m_local_conn, l);
        }
        return null;
    }

    private synchronized native long extractNative(long var1, long var3, long var5, String var7, String var8);

    public void finalize() {
    }

    private void freeXMLType() {
        if (this.m_isClosed) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                if (this.m_clobval == null) break;
                try {
                    if (CLOB.isTemporary((CLOB)this.m_clobval)) {
                        this.m_clobval.freeTemporary();
                    } else {
                        this.m_clobval.close();
                    }
                    this.m_clobval = null;
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 1: 
            case 2: {
                if (this.m_dom != null) {
                    ((XDBDocument)this.m_dom).close();
                }
                try {
                    this.closeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                    this.m_cstate = 0L;
                }
                catch (SQLException sQLException) {
                    this.m_cstate = 0L;
                }
                break;
            }
        }
        this.m_isClosed = true;
    }

    private byte[] getBytesBytes() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 4);
            byteArrayOutputStream.write(this.m_bytesval.toByteArray());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesLob() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 1);
            byteArrayOutputStream.write(this.m_clobval.getLocator());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesPtr(OracleConnection oracleConnection) throws SQLException {
        byte[] byArray = this.pickleXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        return byArray;
    }

    private byte[] getBytesString() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 4);
            byteArrayOutputStream.write(this.m_charSet.convert(this.m_stringval));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getBytesValue() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_clobval != null) {
            return this.getBytesLob();
        }
        if (this.m_stringval != null) {
            return this.getBytesString();
        }
        if (this.m_bytesval != null) {
            return this.getBytesBytes();
        }
        if (this.m_conntype == 2 || this.m_conntype == 1) {
            return this.getBytesPtr(this.m_local_conn);
        }
        return null;
    }

    private void getCStateFromLocator(CLOB cLOB) throws SQLException {
        switch (this.m_conntype) {
            case 0: {
                this.m_clobval = cLOB;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), cLOB.getLocator(), null, false, false);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_clobval = cLOB;
                }
                break;
            }
        }
    }

    private String getClobStr(CLOB cLOB) throws SQLException {
        String string = null;
        try {
            int n;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] cArray = new char[1024];
            Reader reader = cLOB.getCharacterStream();
            while ((n = reader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            reader.close();
            string = charArrayWriter.toString();
            charArrayWriter.close();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        return string;
    }

    public CLOB getClobVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_clobval != null) {
            return this.m_clobval;
        }
        if (this.m_stringval != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            cLOB.putString(1L, this.m_stringval);
            return cLOB;
        }
        if (this.m_cstate != 0L) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            this.printToClobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, cLOB.getLocator());
            return cLOB;
        }
        if (this.m_bytesval != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            cLOB.putString(1L, this.getStringFromBinaryStream());
            return cLOB;
        }
        return null;
    }

    public Document getDOM() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        switch (this.m_conntype) {
            case 0: {
                DOMParser dOMParser = new DOMParser();
                if (this.m_stringval != null) {
                    try {
                        dOMParser.parse((Reader)new StringReader(this.m_stringval));
                    }
                    catch (XMLParseException xMLParseException) {
                        throw new SQLException();
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                    catch (SAXException sAXException) {
                        throw new SQLException();
                    }
                    this.m_dom = dOMParser.getDocument();
                    break;
                }
                if (this.m_clobval != null) {
                    try {
                        dOMParser.parse(this.m_clobval.getCharacterStream());
                    }
                    catch (XMLParseException xMLParseException) {
                        throw new SQLException(((SAXException)((Object)xMLParseException)).getMessage());
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                    catch (SAXException sAXException) {
                        throw new SQLException(sAXException.getMessage());
                    }
                    this.m_dom = dOMParser.getDocument();
                    break;
                }
                if (this.m_bytesval == null) break;
                try {
                    dOMParser.parse((Reader)new StringReader(this.getStringFromBinaryStream()));
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = dOMParser.getDocument();
                break;
            }
            case 1: 
            case 2: {
                long l = this.getXobdFromXMLType(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                this.m_dom = new XDBDocument(this, (Connection)this.m_local_conn, l);
                break;
            }
        }
        return this.m_dom;
    }

    private long getErrHandle() throws SQLException {
        long l;
        switch (this.m_conntype) {
            case 1: {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                l = Long.parseLong(properties.getProperty("OCIErrHandle"));
                break;
            }
            default: {
                l = 0L;
            }
        }
        return l;
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long l = this.getInputStreamNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
        return new RealInputStream(this.getErrHandle(), l);
    }

    private synchronized native long getInputStreamNative(long var1, long var3, long var5);

    public String getNamespace() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getNamespaceNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native String getNamespaceNative(long var1, long var3, long var5);

    public NUMBER getNumberVal() throws SQLException {
        NUMBER nUMBER = null;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        String string = this.getStringVal();
        nUMBER = NUMBER.formattedTextToNumber((String)string, null, null);
        return nUMBER;
    }

    public static ORADataFactory getORADataFactory() {
        return xmlfactory;
    }

    public String getRootElement() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getRootElementNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native String getRootElementNative(long var1, long var3, long var5);

    public String getSchemaURL() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getSchemaURLNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native String getSchemaURLNative(long var1, long var3, long var5);

    private String getStringFromBinaryStream() throws SQLException {
        if (this.m_bytesval == null) {
            return null;
        }
        return this.m_bytesval.toString();
    }

    public String getStringVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_stringval != null) {
            return this.m_stringval;
        }
        if (this.m_clobval != null) {
            return this.getClobStr(this.m_clobval);
        }
        if (this.m_cstate != 0L) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            byte[] byArray = cLOB.getLocator();
            this.printToClobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, cLOB.getLocator());
            String string = this.getClobStr(cLOB);
            CLOB.freeTemporary((CLOB)cLOB);
            return string;
        }
        if (this.m_bytesval != null) {
            return this.getStringFromBinaryStream();
        }
        if (this.m_dom != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            switch (this.m_conntype) {
                case 0: {
                    try {
                        ((XMLDocument)this.m_dom).print(cLOB.getAsciiOutputStream());
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                }
                case 1: 
                case 2: {
                    this.printToClobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, cLOB.getLocator());
                    break;
                }
            }
            String string = this.getClobStr(cLOB);
            CLOB.freeTemporary((CLOB)cLOB);
            return string;
        }
        return null;
    }

    private long getSvcHandle() throws SQLException {
        long l;
        switch (this.m_conntype) {
            case 1: {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                break;
            }
            default: {
                l = 0L;
            }
        }
        return l;
    }

    private static synchronized native long getXMLTypeFromXobd(long var0, long var2, long var4, long var6);

    private native long getXMLTypeNative(long var1, long var3, long var5, byte[] var7);

    private synchronized native long getXobdFromXMLType(long var1, long var3, long var5, long var7);

    private void initConn(Connection connection) throws SQLException {
        block9: {
            this.m_local_conn = (OracleConnection)connection;
            if (this.m_local_conn.getProtocolType().equals("thin")) {
                this.m_conntype = 0;
            } else if (this.m_local_conn.getProtocolType().equals("oci8") || this.m_local_conn.getProtocolType().equals("oci")) {
                this.m_conntype = 1;
                try {
                    if (m_libLoaded) break block9;
                    String string = System.getProperty("os.name");
                    if (string.toUpperCase().startsWith("WINDOWS")) {
                        System.loadLibrary("orageneric9");
                        m_libLoaded = true;
                        break block9;
                    }
                    m_libLoaded = true;
                }
                catch (Exception exception) {
                    this.m_conntype = 0;
                }
            } else if (this.m_local_conn.getProtocolType().equals("kprb")) {
                this.m_conntype = 2;
                this.m_gpCState = XDBContext.getServerEnv();
            } else {
                throw new SQLException("Unknown connection type.");
            }
        }
    }

    private void int2Byte(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)((n &= 0xFFFFFF) >> 16);
        byArray[2] = (byte)((n &= 0xFFFF) >> 8);
        byArray[3] = (byte)(n &= 0xFF);
    }

    public boolean isFragment() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean bl = this.isFragmentNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
        return bl;
    }

    private synchronized native boolean isFragmentNative(long var1, long var3, long var5);

    public boolean isSchemaBased() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaBasedNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native boolean isSchemaBasedNative(long var1, long var3, long var5);

    public boolean isSchemaValid(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean bl = this.isSchemaValidNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, string, string2);
        return bl;
    }

    private synchronized native boolean isSchemaValidNative(long var1, long var3, long var5, String var7, String var8);

    public boolean isSchemaValidated() throws SQLException {
        boolean bl = false;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaValidatedNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native boolean isSchemaValidatedNative(long var1, long var3, long var5);

    private synchronized native byte[] pickleXMLTypeNative(long var1, long var3, long var5, long var7);

    private synchronized native void printToClobNative(long var1, long var3, long var5, long var7, byte[] var9);

    private void processCState(byte[] byArray, int n) throws SQLException {
        this.m_cstate = this.getXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), byArray);
    }

    private void processLob(byte[] byArray, int n) throws SQLException {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.m_clobval = new CLOB((oracle.jdbc.OracleConnection)this.m_local_conn, byArray2);
    }

    private String processString(CharacterSet characterSet, byte[] byArray, int n) throws SQLException {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        return characterSet.toString(byArray2, 0, byArray2.length);
    }

    private void processThin(byte[] byArray, int n) throws SQLException {
        short s = Util.getUnsignedByte((byte)byArray[n]);
        ++n;
        if (s != 1) {
            throw new SQLException("error occurred in XMLtype conversion" + s);
        }
        int n2 = XMLType.bytesToInt(byArray, n);
        n += 4;
        if ((n2 & 1) == 1) {
            this.processLob(byArray, n);
        } else if ((n2 & 4) == 4) {
            this.m_stringval = this.processString(this.m_charSet, byArray, n);
        } else {
            throw new SQLException("Only LOB or thin Storage is supported in Thin XMLType");
        }
    }

    public void schemaValidate() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.schemaValidateNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native void schemaValidateNative(long var1, long var3, long var5);

    public void setSchemaValidated(boolean bl) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.setSchemaValidatedNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, bl);
    }

    private synchronized native void setSchemaValidatedNative(long var1, long var3, long var5, boolean var7);

    public byte[] toBytes() throws SQLException {
        return ((OPAQUE)this.toDatum((Connection)this.m_local_conn)).toBytes();
    }

    public Datum toDatum(Connection connection) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        switch (this.m_conntype) {
            case 0: {
                return new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)this.getBytesValue());
            }
            case 1: 
            case 2: {
                byte[] byArray = this.getBytesPtr((OracleConnection)connection);
                OPAQUE oPAQUE = new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)byArray);
                return oPAQUE;
            }
        }
        return null;
    }

    public XMLType transform(XMLType xMLType, String string) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0 || xMLType == null) {
            throw new SQLException();
        }
        long l = this.transformNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, xMLType.m_cstate, string);
        if (l != 0L) {
            return new XMLType((Connection)this.m_local_conn, l);
        }
        return null;
    }

    private synchronized native long transformNative(long var1, long var3, long var5, long var7, String var9);

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private void writePreamble(ByteArrayOutputStream byteArrayOutputStream, int n, int n2) throws IOException {
        byteArrayOutputStream.write(1);
        byte[] byArray = new byte[4];
        this.int2Byte(n2, byArray);
        byteArrayOutputStream.write(byArray);
    }

    public void writeToOutputStream(OutputStream outputStream) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        InputStream inputStream = this.getInputStream();
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException();
        }
    }
}

