/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.sql.Connection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBCData;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDOMException;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocumentType;
import oracle.xdb.dom.XDBDomImplementation;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBEntityReference;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBNodeList;
import oracle.xdb.dom.XDBNotImplementedException;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import oracle.xdb.spi.XDBContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XDBDocument
extends XDBNode
implements Document {
    static final String NAME_NAMESPACE_SEPARATOR = ":";
    private XMLType m_parentXML = null;

    public XDBDocument() {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = null;
        this.m_xobcstate = this.createNative(XDBDocument.getGP(this.m_conn));
    }

    public XDBDocument(String string) {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = null;
        this.m_xobcstate = this.createFromStringNative(XDBDocument.getGP(this.m_conn), string);
    }

    public XDBDocument(Connection connection) throws Exception {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = connection;
        this.m_xobcstate = this.createNative(XDBDocument.getGP(connection));
    }

    public XDBDocument(Connection connection, long l) {
        super(null, l, (short)9);
        this.m_owner = this;
        this.m_conn = connection;
        this.m_xobcstate = l;
    }

    public XDBDocument(Connection connection, String string) throws Exception {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = connection;
        this.m_xobcstate = this.createFromStringNative(XDBDocument.getGP(connection), string);
    }

    public XDBDocument(Connection connection, byte[] byArray) throws Exception {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = connection;
        this.m_xobcstate = this.createFromBytesNative(XDBDocument.getGP(connection), byArray);
    }

    public XDBDocument(XMLType xMLType, Connection connection, long l) {
        super(null, l, (short)9);
        this.m_parentXML = xMLType;
        this.m_owner = this;
        this.m_conn = connection;
        this.m_xobcstate = l;
    }

    public XDBDocument(byte[] byArray) {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = null;
        this.m_xobcstate = this.createFromBytesNative(XDBDocument.getGP(this.m_conn), byArray);
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (!(node instanceof XDBNode)) {
            throw new XDBDOMException(9, "argument must be an XDBNode");
        }
        if (node.getNodeType() != 1 && node.getNodeType() != 11) {
            throw new XDBDOMException(9, "");
        }
        XDBNode xDBNode = (XDBNode)node;
        super.appendChild(node);
        return node;
    }

    public void close() {
        this.freeDocument();
    }

    public Attr createAttribute(String string) throws DOMException {
        String string2;
        String string3;
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        int n = string.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        long l = this.createAttributeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, null, string3, string2);
        return new XDBAttribute(this, l);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        String string3;
        String string4;
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        int n = string2.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        if (n >= 0) {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        } else {
            string4 = "";
            string3 = string2;
        }
        long l = this.createAttributeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string, string4, string3);
        return new XDBAttribute(this, l);
    }

    private synchronized native long createAttributeNative(long var1, long var3, String var5, String var6, String var7);

    public CDATASection createCDATASection(String string) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.createTextNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string);
        return new XDBCData(this, l);
    }

    public Comment createComment(String string) {
        if (this.m_closed) {
            return null;
        }
        long l = this.createCommentNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string);
        return new XDBComment(this, l);
    }

    private synchronized native long createCommentNodeNative(long var1, long var3, String var5);

    public DocumentFragment createDocumentFragment() {
        if (this.m_closed) {
            return null;
        }
        long l = this.createDocumentFragmentNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        return new XDBDocFragment(this, l);
    }

    private synchronized native long createDocumentFragmentNative(long var1, long var3);

    public Element createElement(String string) throws DOMException {
        String string2;
        String string3;
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        int n = string.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        long l = this.createElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, null, string3, string2);
        return new XDBElement(this, l);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        String string3;
        String string4;
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        int n = string2.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        if (n >= 0) {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        } else {
            string4 = "";
            string3 = string2;
        }
        long l = this.createElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string, string4, string3);
        return new XDBElement(this, l);
    }

    private synchronized native long createElementNative(long var1, long var3, String var5, String var6, String var7);

    private synchronized native long createEntityRefNative(long var1, long var3, String var5);

    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.createEntityRefNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string);
        if (l == 0L) {
            return null;
        }
        return new XDBEntityReference(this, l);
    }

    private synchronized native long createFromBytesNative(long var1, byte[] var3);

    private synchronized native long createFromStringNative(long var1, String var3);

    private synchronized native long createNative(long var1);

    private synchronized native long createPINodeNative(long var1, long var3, String var5, String var6);

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.m_closed) {
            return null;
        }
        long l = this.createPINodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string, string2);
        return new XDBProcInst(this, l);
    }

    public Text createTextNode(String string) {
        if (this.m_closed) {
            return null;
        }
        long l = this.createTextNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string);
        return new XDBText(this, l);
    }

    private synchronized native long createTextNodeNative(long var1, long var3, String var5);

    private synchronized native void destroyNative(long var1, long var3);

    public void finalize() throws Throwable {
    }

    private void freeDocument() {
        if (this.m_closed) {
            return;
        }
        if (this.m_parentXML != null) {
            this.m_closed = true;
            return;
        }
        if (this.m_xobcstate != 0L) {
            this.destroyNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
            this.m_xobcstate = 0L;
            this.m_closed = true;
        }
    }

    private synchronized native long getDocTypeNative(long var1, long var3);

    public DocumentType getDoctype() {
        if (this.m_closed) {
            return null;
        }
        long l = this.getDocTypeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        if (l == 0L) {
            return null;
        }
        return new XDBDocumentType(this, l);
    }

    public Element getDocumentElement() {
        if (this.m_closed) {
            return null;
        }
        long l = this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        if (l == 0L) {
            return null;
        }
        return new XDBElement(this, l);
    }

    private synchronized native long getDocumentElementNative(long var1, long var3);

    public Element getElementById(String string) {
        if (this.m_closed) {
            return null;
        }
        throw new XDBNotImplementedException();
    }

    public NodeList getElementsByTagName(String string) {
        if (this.m_closed) {
            return null;
        }
        long l = this.getElementsByTagNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, null, string);
        if (l == 0L) {
            return null;
        }
        return new XDBNodeList(l, this);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        if (this.m_closed) {
            return null;
        }
        long l = this.getElementsByTagNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, string, string2);
        if (l == 0L) {
            return null;
        }
        return new XDBNodeList(l, this);
    }

    private synchronized native long getElementsByTagNative(long var1, long var3, String var5, String var6);

    public static synchronized native long getEnvNative(OCIDBAccess var0);

    public Node getFirstChild() {
        if (this.m_closed) {
            return null;
        }
        return super.getFirstChild();
    }

    protected static long getGP(Connection connection) {
        long l;
        if (connection == null || ((OracleConnection)connection).getProtocolType().equals("kprb")) {
            l = XDBContext.getServerEnv();
        } else {
            OracleConnection oracleConnection = (OracleConnection)connection;
            l = oracleConnection.db_access instanceof OCIDBAccess ? XDBDocument.getEnvNative((OCIDBAccess)oracleConnection.db_access) : 0L;
        }
        return l;
    }

    public DOMImplementation getImplementation() {
        if (this.m_closed) {
            return null;
        }
        return new XDBDomImplementation(this.m_conn);
    }

    public Node getLastChild() {
        if (this.m_closed) {
            return null;
        }
        return super.getLastChild();
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        if (this.m_closed) {
            return null;
        }
        return "#document";
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        short s = node.getNodeType();
        if (s == 9 || s == 10) {
            throw new XDBDOMException(9, "Node type not supported");
        }
        throw new XDBNotImplementedException();
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        if (l == 0L) {
            if (!(node instanceof XDBNode)) {
                throw new XDBDOMException(9, "argument must be an XDBNode");
            }
            XDBNode xDBNode = (XDBNode)node;
            this.setDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, xDBNode.toCState());
            return node;
        }
        throw new XDBDOMException(3, "");
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (!(node instanceof XDBNode)) {
            throw new XDBDOMException(9, "argument must be an XDBNode");
        }
        XDBNode xDBNode = (XDBNode)node;
        if (xDBNode.toCState() == this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate)) {
            this.removeDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
            return node;
        }
        throw new XDBDOMException(8, "");
    }

    private synchronized native long removeDocumentElementNative(long var1, long var3);

    private synchronized native long replDocumentElementNative(long var1, long var3);

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode xDBNode = (XDBNode)node2;
        if (xDBNode.toCState() == this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate) && node.getNodeType() == 1) {
            this.insertBefore(node, node2);
            this.removeChild(node2);
        }
        return node2;
    }

    private synchronized native long setDocumentElementNative(long var1, long var3, long var5);
}

